/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FiniteFluid
extends Fluid {
    public static final IntegerProperty LEVEL = ModBlockProperties.FINITE_FLUID_LEVEL;
    private final Map<FluidState, VoxelShape> shapes = Maps.newIdentityHashMap();
    protected final int maxLayers;
    private final Supplier<? extends BucketItem> bucket;
    private final Supplier<? extends Block> block;

    public FiniteFluid(int maxLayers, Supplier<? extends Block> block, Supplier<? extends BucketItem> bucket) {
        this.maxLayers = maxLayers;
        this.block = block;
        this.bucket = bucket;
        this.registerDefaultState((FluidState)((FluidState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(maxLayers)));
    }

    public int getLayersPerBlock() {
        return this.maxLayers;
    }

    public Item getBucket() {
        return (Item)this.bucket.get();
    }

    protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
        builder.add(new Property[]{LEVEL});
    }

    public Vec3 getFlow(BlockGetter blockReader, BlockPos pos, FluidState fluidState) {
        return Vec3.ZERO;
    }

    /*
     * WARNING - void declaration
     */
    private void spreadToSides(Level level, BlockPos pos, FluidState fluidState, BlockState blockState) {
        int currentAmount = fluidState.getAmount();
        if (currentAmount > 1) {
            Map<Direction, Integer> map = this.getWantedSpreadDirections((BlockGetter)level, pos, blockState);
            ArrayList<Map.Entry<Direction, Integer>> entryList = new ArrayList<Map.Entry<Direction, Integer>>(map.entrySet());
            Collections.shuffle(entryList);
            map = new LinkedHashMap<Direction, Integer>();
            for (Map.Entry entry : entryList) {
                map.put((Direction)entry.getKey(), (Integer)entry.getValue());
            }
            int initialAmount = currentAmount;
            map.values().removeIf(i -> i >= initialAmount);
            boolean bl = true;
            block1: while (currentAmount <= map.size()) {
                void var9_12;
                void finalR = var9_12++;
                Iterator<Map.Entry<Direction, Integer>> iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Direction, Integer> e = iter.next();
                    if (e.getValue() > initialAmount - finalR) {
                        iter.remove();
                    }
                    if (currentAmount <= map.size()) continue;
                    continue block1;
                }
            }
            for (Map.Entry<Direction, Integer> e : map.entrySet()) {
                int oldAmount = e.getValue();
                Direction dir = e.getKey();
                BlockPos facingPos = pos.relative(dir);
                BlockState s = level.getBlockState(facingPos);
                FluidState fluidstate = this.makeState(oldAmount + 1);
                this.spreadTo((LevelAccessor)level, facingPos, s, dir, fluidstate);
            }
            if (!map.isEmpty()) {
                FluidState myNewState = this.makeState(currentAmount - map.size());
                BlockState blockstate = (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL, (Comparable)((Integer)myNewState.createLegacyBlock().getValue((Property)BlockStateProperties.LEVEL)));
                level.setBlock(pos, blockstate, 2);
                level.updateNeighborsAt(pos, blockstate.getBlock());
            }
        }
    }

    public FluidState makeState(int level) {
        return (FluidState)this.defaultFluidState().setValue((Property)LEVEL, (Comparable)Integer.valueOf(level));
    }

    protected void spreadTo(LevelAccessor level, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer container = (LiquidBlockContainer)block;
            container.placeLiquid(level, pos, blockState, fluidState);
        } else if (blockState.getFluidState().is((Fluid)this)) {
            level.setBlock(pos, (BlockState)blockState.setValue((Property)BlockStateProperties.LEVEL, (Comparable)((Integer)fluidState.createLegacyBlock().getValue((Property)BlockStateProperties.LEVEL))), 3);
        } else {
            if (!blockState.isAir()) {
                this.beforeDestroyingBlock(level, pos, blockState);
            }
            level.setBlock(pos, fluidState.createLegacyBlock(), 3);
        }
    }

    protected Map<Direction, Integer> getWantedSpreadDirections(BlockGetter level, BlockPos pos, BlockState state) {
        HashMap<Direction, Integer> list = new HashMap<Direction, Integer>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos facingPos = pos.relative(direction);
            BlockState facingState = level.getBlockState(facingPos);
            FluidState facingFluid = facingState.getFluidState();
            if (!this.canHoldFluid(level, facingPos, facingState)) continue;
            list.put(direction, facingFluid.getAmount());
        }
        return list;
    }

    public void tick(Level level, BlockPos pos, FluidState state) {
        if (state.isEmpty()) {
            return;
        }
        BlockState myState = level.getBlockState(pos);
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        FluidState belowFluid = belowState.getFluidState();
        if (belowFluid.getType().isSame((Fluid)this)) {
            if (belowFluid.getAmount() < this.maxLayers) {
                int belowMissing = this.maxLayers - belowFluid.getAmount();
                int belowAddition = Math.min(belowMissing, state.getAmount());
                int newAboveAmount = state.getAmount() - belowAddition;
                level.setBlockAndUpdate(belowPos, ((FluidState)belowFluid.setValue((Property)LEVEL, (Comparable)Integer.valueOf(belowFluid.getAmount() + belowAddition))).createLegacyBlock());
                if (newAboveAmount > 0) {
                    level.setBlockAndUpdate(pos, ((FluidState)state.setValue((Property)LEVEL, (Comparable)Integer.valueOf(newAboveAmount))).createLegacyBlock());
                } else {
                    level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                }
            } else {
                this.spreadToSides(level, pos, state, myState);
            }
            return;
        }
        if (this.canHoldFluid((BlockGetter)level, belowPos, belowState)) {
            this.spreadTo((LevelAccessor)level, belowPos, belowState, Direction.DOWN, state);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        } else {
            this.spreadToSides(level, pos, state, myState);
        }
    }

    private boolean canHoldFluid(BlockGetter level, BlockPos pos, BlockState state) {
        FluidState fluidState = state.getFluidState();
        if (!fluidState.isEmpty() && !fluidState.is((Fluid)this)) {
            return false;
        }
        Block block = state.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer lc = (LiquidBlockContainer)block;
            return lc.canPlaceLiquid(null, level, pos, state, (Fluid)this);
        }
        if (!(block instanceof DoorBlock || state.is(BlockTags.SIGNS) || state.is(Blocks.LADDER) || state.is(Blocks.SUGAR_CANE) || state.is(Blocks.BUBBLE_COLUMN) || state.is(Blocks.NETHER_PORTAL) || state.is(Blocks.END_PORTAL) || state.is(Blocks.END_GATEWAY) || state.is(Blocks.STRUCTURE_VOID))) {
            return !state.blocksMotion();
        }
        return false;
    }

    private static boolean hasSameAbove(FluidState fluidState, BlockGetter level, BlockPos pos) {
        return fluidState.getType().isSame(level.getFluidState(pos.above()).getType());
    }

    public float getHeight(FluidState state, BlockGetter level, BlockPos pos) {
        return FiniteFluid.hasSameAbove(state, level, pos) ? 1.0f : state.getOwnHeight();
    }

    public float getOwnHeight(FluidState state) {
        return 0.875f * (float)state.getAmount() / (float)this.maxLayers;
    }

    public boolean isSource(FluidState state) {
        return true;
    }

    public int getAmount(FluidState state) {
        return (Integer)state.getValue((Property)LEVEL);
    }

    public VoxelShape getShape(FluidState state, BlockGetter level, BlockPos pos) {
        return this.shapes.computeIfAbsent(state, arg3 -> Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)arg3.getHeight(level, pos), (double)1.0));
    }

    public boolean shouldSlowDown(FluidState state) {
        return state.getAmount() > 2;
    }

    protected void beforeDestroyingBlock(LevelAccessor level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected boolean canBeReplacedWith(FluidState state, BlockGetter level, BlockPos pos, Fluid fluid, Direction direction) {
        return true;
    }

    public int getTickDelay(LevelReader level) {
        return 5;
    }

    protected float getExplosionResistance() {
        return 0.0f;
    }

    protected BlockState createLegacyBlock(FluidState state) {
        return (BlockState)this.block.get().defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(this.getLegacyLevel(state)));
    }

    protected int getLegacyLevel(FluidState state) {
        int amount = state.getAmount();
        return this.maxLayers - Math.min(amount, this.maxLayers);
    }
}

