/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonAccess;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.common.block.cannon.CannonUtils;
import net.mehvahdjukaar.supplementaries.common.block.cannon.ShootingMode;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.entities.ICannonShooter;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.phys.Vec3;

public final class PlundererAICommon {
    public static final int TIME_TO_DISMOUNT_BOAT = 15;
    public static final int MAX_USE_CANNON_BOAT = 300;
    public static final int MAX_STAY_TIME = 1000;
    public static final int MAX_TIME_WITHOUT_SHOOTING = 300;
    public static final int MAX_GO_TO_TIME = 1200;
    public static final int MIN_CANNON_RANGE = 16;
    public static final int GOAL_INTERVAL = 90;
    public static final int SHOOTING_COOLDOWN_MIN = 50;
    public static final int SHOOTING_COOLDOWN_MAX = 80;

    public static boolean aimCannonAndShoot(CannonAccess access, Mob shooter, LivingEntity target, boolean canShoot) {
        CannonBlockTile cannonTile = access.getInternalCannon();
        if (cannonTile.isOnCooldown()) {
            return false;
        }
        Vec3 cannonGlobalPosition = access.getCannonGlobalPosition(0.0f);
        Vec3 targetLoc = target.position();
        byte power = 1;
        int maxPower = cannonTile.getFuel().getCount();
        float distance = (float)targetLoc.distanceTo(cannonGlobalPosition);
        if (distance > 64.0f) {
            power = 4;
        } else if (distance > 32.0f) {
            power = 3;
        } else if (distance > 16.0f) {
            power = 2;
        }
        targetLoc = targetLoc.add(target.getDeltaMovement().scale((double)distance * 0.2)).add(0.0, 0.6, 0.0);
        power = (byte)Math.min(power, maxPower);
        cannonTile.setPowerLevel(power);
        Pair<CannonTrajectory, Float> comp = CannonUtils.computeTrajectory(access, targetLoc, ShootingMode.DOWN);
        CannonTrajectory cannonTrajectory = (CannonTrajectory)comp.getFirst();
        float wantedGlobalYawDeg = ((Float)comp.getSecond()).floatValue() * 57.295776f;
        if (cannonTrajectory != null) {
            float newCannonGlobalYaw;
            Vec3 hitLoc;
            double distance1;
            float cannonGlobalYawOffsetDeg = access.getCannonGlobalYawOffset(0.0f);
            float wantedLocalYawDeg = wantedGlobalYawDeg + cannonGlobalYawOffsetDeg;
            PlundererAICommon.setCannonAnglesToFollowTrajectory(access, cannonTrajectory, wantedLocalYawDeg);
            if (canShoot && (distance1 = (hitLoc = cannonTrajectory.getHitLocation(cannonGlobalPosition, newCannonGlobalYaw = (cannonTile.getYaw() - cannonGlobalYawOffsetDeg) * ((float)Math.PI / 180))).distanceTo(targetLoc)) < 0.1 && cannonTile.readyToFire()) {
                cannonTile.ignite((Entity)shooter, access);
                if (shooter instanceof ICannonShooter) {
                    ICannonShooter cs = (ICannonShooter)shooter;
                    cs.onShotCannon(cannonTile.getBlockPos());
                } else if (shooter instanceof Raider) {
                    Raider r = (Raider)shooter;
                    r.playSound(r.getCelebrateSound(), 2.5f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    private static void setCannonAnglesToFollowTrajectory(CannonAccess access, CannonTrajectory trajectory, float wantedLocalYawDeg) {
        if (trajectory != null) {
            float followSpeed = 1.0f;
            CannonBlockTile cannon = access.getInternalCannon();
            cannon.setPitch(access, Mth.rotLerp((float)followSpeed, (float)cannon.getPitch(), (float)(trajectory.pitch() * 57.295776f)));
            cannon.setYaw(access, wantedLocalYawDeg);
            cannon.setChanged();
            access.updateClients();
        }
    }

    public static boolean hasValidTargetInCannonRange(Mob mob, int minCannonRange) {
        LivingEntity target = mob.getTarget();
        if (target == null || !target.isAlive()) {
            return false;
        }
        double distSq = mob.distanceToSqr((Entity)target);
        return distSq > (double)(minCannonRange * minCannonRange);
    }
}

