/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import net.mehvahdjukaar.supplementaries.common.entities.PlundererEntity;
import net.mehvahdjukaar.supplementaries.common.entities.data.LivingEntityTamable;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;

public class ParrotLandOnPlundererGoal
extends Goal {
    private final ShoulderRidingEntity entity;
    private PlundererEntity plunderer;
    private boolean isSittingOnShoulder;

    public ParrotLandOnPlundererGoal(ShoulderRidingEntity entity) {
        this.entity = entity;
    }

    public boolean canUse() {
        LivingEntityTamable tamable = (LivingEntityTamable)ModEntities.LIVING_TAMABLE.getOrCreate((Object)this.entity);
        LivingEntity livingEntity = tamable.getOwner((Mob)this.entity);
        if (!(livingEntity instanceof PlundererEntity)) {
            return false;
        }
        PlundererEntity pl = (PlundererEntity)livingEntity;
        this.plunderer = pl;
        boolean valid = !pl.isUnderWater() && !pl.isInPowderSnow && pl.isAlive() && !pl.isSleeping() && !pl.isAggressive();
        return !this.entity.isOrderedToSit() && valid && this.entity.canSitOnShoulder();
    }

    public boolean isInterruptable() {
        return !this.isSittingOnShoulder;
    }

    public void start() {
        this.isSittingOnShoulder = false;
    }

    public void tick() {
        if (!(this.isSittingOnShoulder || this.entity.isInSittingPose() || this.entity.isLeashed())) {
            double cheatRadius = 0.25;
            if (this.entity.getBoundingBox().inflate(cheatRadius, cheatRadius, cheatRadius).intersects(this.plunderer.getBoundingBox())) {
                this.isSittingOnShoulder = this.plunderer.setEntityOnShoulder((LivingEntity)this.entity);
            }
        }
    }
}

