/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.goals;

import net.mehvahdjukaar.supplementaries.mixins.EndermanAccessor;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class AbandonShipGoal
extends Goal {
    private final Mob mob;
    private final int ticksToDismount;
    private int tickOnEdge = 0;

    public AbandonShipGoal(Mob mob, int ticksToDismount) {
        this.mob = mob;
        this.ticksToDismount = ticksToDismount;
    }

    public AbandonShipGoal(Mob mob) {
        this(mob, 15);
    }

    public boolean canUse() {
        Entity entity = this.mob.getVehicle();
        if (entity instanceof Boat) {
            Boat b = (Boat)entity;
            LivingEntity captain = b.getControllingPassenger();
            if (captain != null && captain != this.mob && captain.getType().is(ModTags.CAN_STEER_BOAT)) {
                return false;
            }
            if (!b.isInWater()) {
                return true;
            }
            if (b.onGround()) {
                return true;
            }
            PathNavigation nav = this.mob.getNavigation();
            return nav.isStuck() || !nav.isDone() && nav.getPath().getNextNode().type != PathType.WATER;
        }
        return false;
    }

    public void start() {
        this.tickOnEdge = 0;
    }

    public void stop() {
        this.tickOnEdge = 0;
    }

    public void tick() {
        if (this.tickOnEdge++ >= this.ticksToDismount) {
            this.doStopRiding();
        }
    }

    protected void doStopRiding() {
        Vec3 oldPos = this.mob.position();
        this.mob.stopRiding();
        Mob mob = this.mob;
        if (mob instanceof EnderMan) {
            EnderMan em = (EnderMan)mob;
            em.setPos(oldPos);
            ((EndermanAccessor)em).invokeTeleport();
        }
    }
}

