/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.cannon;

import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundRequestOpenCannonGuiMessage;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSyncCannonPacket;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public interface CannonAccess {
    public CannonBlockTile getInternalCannon();

    public TileOrEntityTarget makeNetworkTarget();

    public void applyRecoil();

    public boolean canManeuverFromGUI(Player var1);

    public void syncToServer(boolean var1, boolean var2);

    public Vec3 getCannonGlobalPosition(float var1);

    public float getCannonGlobalYawOffset(float var1);

    public Vec3 getCannonGlobalOffset();

    public void sendOpenGuiRequest();

    public void openCannonGui(ServerPlayer var1);

    public boolean stillValid(Player var1);

    public void updateClients();

    default public Vec3 getCannonGlobalFacing(float partialTicks) {
        CannonBlockTile cannon = this.getInternalCannon();
        return Vec3.directionFromRotation((float)cannon.getPitch(partialTicks), (float)(cannon.getYaw(partialTicks) - this.getCannonGlobalYawOffset(partialTicks)));
    }

    default public void setCannonGlobalFacing(Vec3 direction) {
        this.setCannonGlobalFacing(direction, false);
    }

    default public void setCannonGlobalFacing(Vec3 direction, boolean ignoreIfInvalid) {
        CannonBlockTile cannon = this.getInternalCannon();
        float yaw = (float)(MthUtils.getYaw((Vec3)direction) + (double)this.getCannonGlobalYawOffset(0.0f));
        float pitch = (float)MthUtils.getPitch((Vec3)direction);
        float oldYaw = cannon.getYaw(0.0f);
        float oldPitch = cannon.getPitch(0.0f);
        cannon.setYaw(this, yaw);
        cannon.setPitch(this, pitch);
        if (!ignoreIfInvalid) {
            float newYaw = cannon.getYaw(0.0f);
            float newPitch = cannon.getPitch(0.0f);
            if (newYaw != yaw || newPitch != pitch) {
                cannon.setYaw(this, oldYaw);
                cannon.setPitch(this, oldPitch);
            }
        }
    }

    public Restraint getPitchAndYawRestrains();

    public Vec3 getCannonGlobalVelocity();

    default public boolean shouldRotatePlayerFaceWhenManeuvering() {
        return false;
    }

    default public boolean impedePlayerMovementWhenManeuvering() {
        return true;
    }

    public static CannonAccess find(Level level, TileOrEntityTarget target) {
        Object obj = target.getTarget(level);
        if (obj instanceof CannonBlockTile) {
            CannonBlockTile cannon = (CannonBlockTile)((Object)obj);
            return new Block(cannon);
        }
        if (obj instanceof CannonAccess) {
            CannonAccess cannon = (CannonAccess)obj;
            return cannon;
        }
        return null;
    }

    public static CannonAccess block(CannonBlockTile cannonBlockTile) {
        return new Block(cannonBlockTile);
    }

    public Vec3 getCannonRecoil();

    public static class Block
    implements CannonAccess {
        private final CannonBlockTile cannon;

        public Block(CannonBlockTile cannon) {
            this.cannon = cannon;
        }

        @Override
        public TileOrEntityTarget makeNetworkTarget() {
            return TileOrEntityTarget.of((BlockEntity)this.cannon);
        }

        @Override
        public Vec3 getCannonRecoil() {
            return Vec3.ZERO;
        }

        @Override
        public void applyRecoil() {
        }

        @Override
        public Vec3 getCannonGlobalVelocity() {
            return Vec3.ZERO;
        }

        @Override
        public boolean canManeuverFromGUI(Player player) {
            return true;
        }

        @Override
        public Vec3 getCannonGlobalPosition(float ticks) {
            return this.cannon.getBlockPos().getCenter();
        }

        @Override
        public Vec3 getCannonGlobalOffset() {
            return new Vec3(0.5, 0.5, 0.5);
        }

        @Override
        public float getCannonGlobalYawOffset(float partialTicks) {
            return 0.0f;
        }

        @Override
        public CannonBlockTile getInternalCannon() {
            return this.cannon;
        }

        @Override
        public void updateClients() {
            Level level = this.cannon.getLevel();
            level.sendBlockUpdated(this.cannon.getBlockPos(), this.cannon.getBlockState(), this.cannon.getBlockState(), 3);
        }

        @Override
        public void syncToServer(boolean fire, boolean removeOwner) {
            NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundSyncCannonPacket(this.cannon.getYaw(), this.cannon.getPitch(), this.cannon.getPowerLevel(), fire, removeOwner, TileOrEntityTarget.of((BlockEntity)this.cannon)));
        }

        @Override
        public void sendOpenGuiRequest() {
            NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundRequestOpenCannonGuiMessage((BlockEntity)this.cannon));
        }

        @Override
        public void openCannonGui(ServerPlayer player) {
            Utils.openGuiIfPossible((BlockEntity)this.cannon, (ServerPlayer)player, (ItemStack)player.getMainHandItem(), (Direction)Direction.UP);
        }

        @Override
        public boolean stillValid(Player player) {
            Level level = player.level();
            return !this.cannon.isRemoved() && level.getBlockEntity(this.cannon.getBlockPos()) == this.cannon && this.cannon.isCloseEnoughToUse((Entity)player, this.cannon.getBlockPos());
        }

        @Override
        public Restraint getPitchAndYawRestrains() {
            BlockState state = this.cannon.getBlockState();
            return switch (((Direction)state.getValue((Property)CannonBlock.FACING)).getOpposite()) {
                default -> throw new MatchException(null, null);
                case Direction.NORTH -> new Restraint(70.0f, 290.0f, -180.0f, 180.0f);
                case Direction.SOUTH -> new Restraint(-110.0f, 110.0f, -180.0f, 180.0f);
                case Direction.EAST -> new Restraint(-200.0f, 20.0f, -180.0f, 180.0f);
                case Direction.WEST -> new Restraint(-20.0f, 200.0f, -180.0f, 180.0f);
                case Direction.UP -> new Restraint(-360.0f, 360.0f, -200.0f, 20.0f);
                case Direction.DOWN -> new Restraint(-360.0f, 360.0f, -20.0f, 200.0f);
            };
        }
    }

    public record Restraint(float minYaw, float maxYaw, float minPitch, float maxPitch) {
    }
}

