/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlowerBoxBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlowerBoxBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)6.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH_FLOOR = Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)6.0, (double)11.0);
    protected static final VoxelShape SHAPE_WEST_FLOOR = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)6.0, (double)16.0);
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL_0_15;
    public static final EnumProperty<AttachFace> ATTACHMENT = BlockStateProperties.ATTACH_FACE;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public FlowerBoxBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(s -> (Integer)s.getValue((Property)LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(ATTACHMENT, (Comparable)AttachFace.WALL)).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!MiscUtils.showsHints(tooltipFlag) || CommonConfigs.Building.FLOWER_BOX_SIMPLE_MODE.get().booleanValue()) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"message.supplementaries.flower_box").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, ATTACHMENT, LIGHT_LEVEL});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction dir = context.getClickedFace();
        AttachFace attachface = switch (dir) {
            case Direction.UP -> AttachFace.FLOOR;
            case Direction.DOWN -> AttachFace.CEILING;
            default -> AttachFace.WALL;
        };
        BlockState blockstate = super.getStateForPlacement(context);
        return (BlockState)((BlockState)blockstate.setValue(ATTACHMENT, (Comparable)attachface)).setValue((Property)FACING, (Comparable)(dir.getAxis().isVertical() ? context.getHorizontalDirection().getOpposite() : dir));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.canSurvive(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState s = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (stateIn.getValue(ATTACHMENT) == AttachFace.CEILING && facing == Direction.UP && !facingState.isSolid()) {
            s = (BlockState)s.setValue(ATTACHMENT, (Comparable)AttachFace.FLOOR);
        }
        return s;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FlowerBoxBlockTile) {
            FlowerBoxBlockTile tile = (FlowerBoxBlockTile)blockEntity;
            int ind = FlowerBoxBlock.getIndex(state, pos, hitResult);
            return tile.interactWithPlayerItem(player, hand, stack, ind);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private static int getIndex(BlockState state, BlockPos pos, BlockHitResult hit) {
        int ind;
        if (CommonConfigs.Building.FLOWER_BOX_SIMPLE_MODE.get().booleanValue()) {
            return 1;
        }
        Direction dir = (Direction)state.getValue((Property)FACING);
        Vec3 v = hit.getLocation();
        v = v.subtract((double)pos.getX() - 1.0, 0.0, (double)pos.getZ() - 1.0);
        if (dir.getAxis() == Direction.Axis.X) {
            double normalizedZ = Math.abs(v.z % 1.0);
            ind = v.z >= 2.0 ? 2 : (int)(normalizedZ / 0.3333333333333333);
            if (dir.getStepX() < 0) {
                ind = 2 - ind;
            }
        } else {
            double normalizedX = Math.abs(v.x % 1.0);
            ind = v.x >= 2.0 ? 2 : (int)(normalizedX / 0.3333333333333333);
            if (dir.getStepZ() > 0) {
                ind = 2 - ind;
            }
        }
        return ind;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FlowerBoxBlockTile(pPos, pState);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean wall = state.getValue(ATTACHMENT) == AttachFace.WALL;
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> {
                if (wall) {
                    yield SHAPE_SOUTH;
                }
                yield SHAPE_NORTH_FLOOR;
            }
            case Direction.EAST -> {
                if (wall) {
                    yield SHAPE_EAST;
                }
                yield SHAPE_WEST_FLOOR;
            }
            case Direction.WEST -> {
                if (wall) {
                    yield SHAPE_WEST;
                }
                yield SHAPE_WEST_FLOOR;
            }
            default -> wall ? SHAPE_NORTH : SHAPE_NORTH_FLOOR;
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        ItemDisplayTile tile;
        ItemStack i;
        BlockEntity blockEntity;
        BlockHitResult hit;
        if (target instanceof BlockHitResult && (hit = (BlockHitResult)target).getDirection() == Direction.UP && (blockEntity = world.getBlockEntity(pos)) instanceof ItemDisplayTile && !(i = (tile = (ItemDisplayTile)blockEntity).getItem(FlowerBoxBlock.getIndex(state, pos, hit))).isEmpty()) {
            return i;
        }
        return super.getCloneItemStack(world, pos, state);
    }
}

