/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IColored;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.IRopeConnection;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpWaterBlock;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CandleHolderBlock
extends LightUpWaterBlock
implements IColored {
    protected static final VoxelShape SHAPE_FLOOR = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_NORTH = Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_WALL_SOUTH = Block.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    protected static final VoxelShape SHAPE_WALL_WEST = Block.box((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_EAST = Block.box((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_CEILING = Block.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.ATTACH_FACE;
    public static final IntegerProperty CANDLES = BlockStateProperties.CANDLES;
    private static final EnumMap<Direction, EnumMap<AttachFace, Int2ObjectMap<List<Vec3>>>> PARTICLE_OFFSETS = new EnumMap(Direction.class);
    @Nullable
    public final DyeColor color;
    public final Supplier<ParticleType<? extends ParticleOptions>> particle;
    public final Function<BlockState, List<Vec3>> particleOffsets;

    public static List<Vec3> getDefaultParticleOffsets(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        AttachFace face = (AttachFace)state.getValue(FACE);
        int candles = (Integer)state.getValue((Property)CANDLES);
        return (List)PARTICLE_OFFSETS.get(direction).get(face).get(candles);
    }

    @Deprecated(forRemoval=true)
    public static List<Vec3> getParticleOffsets(BlockState state) {
        return CandleHolderBlock.getDefaultParticleOffsets(state);
    }

    @Deprecated(forRemoval=true)
    public CandleHolderBlock(DyeColor color, BlockBehaviour.Properties properties) {
        this(color, properties, () -> ParticleTypes.SMALL_FLAME, CandleHolderBlock::getDefaultParticleOffsets);
    }

    @Deprecated(forRemoval=true)
    public CandleHolderBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties, Supplier<ParticleType<? extends ParticleOptions>> particle) {
        this(color, properties, particle, CandleHolderBlock::getDefaultParticleOffsets);
    }

    public CandleHolderBlock(DyeColor color, BlockBehaviour.Properties properties, Function<BlockState, List<Vec3>> particleOffsets) {
        this(color, properties, () -> ParticleTypes.SMALL_FLAME, particleOffsets);
    }

    public CandleHolderBlock(@Nullable DyeColor color, BlockBehaviour.Properties properties, Supplier<ParticleType<? extends ParticleOptions>> particle, Function<BlockState, List<Vec3>> particleOffsets) {
        super(properties.lightLevel(CandleHolderBlock::lightLevel));
        this.particleOffsets = particleOffsets;
        this.color = color;
        this.particle = particle;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue(FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CANDLES, (Comparable)Integer.valueOf(1)));
    }

    private static int lightLevel(BlockState state) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            int candles = (Integer)state.getValue((Property)CANDLES);
            return 7 + candles * 2;
        }
        return 0;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        if (blockState.is((Block)this)) {
            return (BlockState)blockState.setValue((Property)CANDLES, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockState.getValue((Property)CANDLES) + 1)));
        }
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate = direction.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection()) : (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!blockstate.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)((BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)CANDLES) < 4 || super.canBeReplaced(state, useContext);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACE, FACING, CANDLES});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((AttachFace)state.getValue(FACE)) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> SHAPE_FLOOR;
            case AttachFace.WALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case SOUTH: {
                        yield SHAPE_WALL_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_WALL_WEST;
                    }
                    case EAST: {
                        yield SHAPE_WALL_EAST;
                    }
                }
                yield SHAPE_WALL_NORTH;
            }
            case AttachFace.CEILING -> SHAPE_CEILING;
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ec;
        return context instanceof EntityCollisionContext && (ec = (EntityCollisionContext)context).getEntity() instanceof Projectile ? state.getShape(level, pos) : Shapes.empty();
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.getValue(FACE) == AttachFace.FLOOR) {
            return CandleHolderBlock.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.below(), (Direction)Direction.UP);
        }
        if (state.getValue(FACE) == AttachFace.CEILING) {
            return IRopeConnection.isSupportingCeiling(pos.above(), worldIn);
        }
        return CandleHolderBlock.isSideSolidForDirection(worldIn, pos, ((Direction)state.getValue((Property)FACING)).getOpposite());
    }

    private void addParticlesAndSound(Level level, Vec3 offset, RandomSource random) {
        float f = random.nextFloat();
        if (f < 0.3f) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                level.playLocalSound(offset.x + 0.5, offset.y + 0.5, offset.z + 0.5, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + random.nextFloat(), random.nextFloat() * 0.7f + 0.3f, false);
            }
        }
        level.addParticle((ParticleOptions)this.particle.get(), offset.x, offset.y, offset.z, 0.0, 0.0, 0.0);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            this.particleOffsets.apply(state).forEach(v -> this.addParticlesAndSound(level, v.add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), rand));
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @Override
    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return CandleHolderBlock.getFacing(stateIn).getOpposite() == facing && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected static Direction getFacing(BlockState state) {
        return switch ((AttachFace)state.getValue(FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)state.getValue((Property)FACING);
        };
    }

    public static boolean isSideSolidForDirection(LevelReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.relative(direction);
        return reader.getBlockState(blockpos).isFaceSturdy((BlockGetter)reader, blockpos, direction.getOpposite());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!MiscUtils.showsHints(tooltipFlag)) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"message.supplementaries.candle_holder").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public boolean supportsBlankColor() {
        return true;
    }

    public boolean canBeExtinguishedBy(ItemStack item) {
        return item.isEmpty() || super.canBeExtinguishedBy(item);
    }

    public void playExtinguishSound(LevelAccessor world, BlockPos pos) {
        world.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void spawnSmokeParticles(BlockState state, BlockPos pos, LevelAccessor level) {
        this.particleOffsets.apply(state).forEach(vec3 -> level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + vec3.x(), (double)pos.getY() + vec3.y(), (double)pos.getZ() + vec3.z(), 0.0, (double)0.1f, 0.0));
    }

    static {
        EnumMap<AttachFace, Int2ObjectMap> temp = new EnumMap<AttachFace, Int2ObjectMap>(AttachFace.class);
        Int2ObjectArrayMap int2ObjectMap = new Int2ObjectArrayMap();
        int2ObjectMap.put(1, List.of(new Vec3(0.5, 0.6875, 0.5)));
        int2ObjectMap.put(2, List.of(new Vec3(0.3125, 0.875, 0.5), new Vec3(0.6875, 0.875, 0.5)));
        int2ObjectMap.put(3, List.of(new Vec3(0.1875, 0.9375, 0.5), new Vec3(0.5, 0.9375, 0.5), new Vec3(0.8125, 0.9375, 0.5)));
        int2ObjectMap.put(4, List.of(new Vec3(0.1875, 1.0, 0.5), new Vec3(0.8125, 1.0, 0.5), new Vec3(0.5, 0.9375, 0.25), new Vec3(0.5, 0.9375, 0.75)));
        temp.put(AttachFace.FLOOR, Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2ObjectMap));
        int2ObjectMap = new Int2ObjectArrayMap();
        int2ObjectMap.put(1, List.of(new Vec3(0.5, 0.9375, 0.1875)));
        int2ObjectMap.put(2, List.of(new Vec3(0.3125, 0.9375, 0.1875), new Vec3(0.6875, 0.9375, 0.1875)));
        int2ObjectMap.put(3, List.of(new Vec3(0.8125, 0.9375, 0.1875), new Vec3(0.1875, 0.9375, 0.1875), new Vec3(0.5, 0.9375, 0.3125)));
        int2ObjectMap.put(4, List.of(new Vec3(0.1875, 1.0, 0.1875), new Vec3(0.8125, 1.0, 0.1875), new Vec3(0.3125, 0.875, 0.3125), new Vec3(0.6875, 0.875, 0.3125)));
        temp.put(AttachFace.WALL, Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2ObjectMap));
        int2ObjectMap = new Int2ObjectArrayMap();
        int2ObjectMap.put(1, List.of(new Vec3(0.5, 0.5625, 0.5)));
        int2ObjectMap.put(2, List.of(new Vec3(0.25, 0.875, 0.5), new Vec3(0.75, 0.875, 0.5)));
        int2ObjectMap.put(3, List.of(new Vec3(0.5, 0.875, 0.75), new Vec3(0.75, 0.875, 0.375), new Vec3(0.25, 0.875, 0.375)));
        int2ObjectMap.put(4, List.of(new Vec3(0.1875, 0.8125, 0.1875), new Vec3(0.8125, 0.8125, 0.1875), new Vec3(0.8125, 0.8125, 0.8125), new Vec3(0.1875, 0.8125, 0.8125)));
        temp.put(AttachFace.CEILING, Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2ObjectMap));
        for (Direction direction : Direction.values()) {
            EnumMap<AttachFace, Int2ObjectMap> newFaceMap = new EnumMap<AttachFace, Int2ObjectMap>(AttachFace.class);
            for (Map.Entry faceList : temp.entrySet()) {
                Int2ObjectArrayMap newCandleList = new Int2ObjectArrayMap();
                newCandleList.defaultReturnValue(List.of());
                int c = 1;
                Int2ObjectMap oldVec = (Int2ObjectMap)faceList.getValue();
                for (int i = 1; i < 5; ++i) {
                    ArrayList<Vec3> vectorsList = new ArrayList<Vec3>();
                    for (Vec3 vec : (List)oldVec.get(i)) {
                        vectorsList.add(MthUtils.rotateVec3((Vec3)vec.subtract(0.5, 0.5, 0.5), (Direction)direction.getOpposite()).add(0.5, 0.5, 0.5));
                    }
                    newCandleList.put(c++, (Object)ImmutableList.copyOf(vectorsList));
                }
                newFaceMap.put(faceList.getKey(), Int2ObjectMaps.unmodifiable((Int2ObjectMap)newCandleList));
            }
            PARTICLE_OFFSETS.put(direction, newFaceMap);
        }
    }
}

