/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.MultiLineEditBoxWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PlayerSuggestionBoxWidget
extends MultiLineEditBoxWidget {
    private static final Map<UUID, String> USERNAME_CACHE = new HashMap<UUID, String>();
    private static final Component EMPTY_SEARCH = Component.translatable((String)"gui.supplementaries.present.send").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC);
    private final List<SimplePlayerEntry> allPlayers = new ArrayList<SimplePlayerEntry>();
    private final List<SimplePlayerEntry> filtered = new ArrayList<SimplePlayerEntry>();
    private SimplePlayerEntry selectedPlayer = null;
    @Nullable
    private String suggestion;
    private String fullSuggestion = "";

    public static void setUsernameCache(Map<UUID, String> usernameCache) {
        USERNAME_CACHE.clear();
        USERNAME_CACHE.putAll(usernameCache);
    }

    public PlayerSuggestionBoxWidget(Minecraft mc, int x, int y, int width, int height) {
        super(mc, x, y, width, height);
        Collection onlinePlayers = mc.player.connection.getOnlinePlayerIds();
        for (UUID uUID : onlinePlayers) {
            PlayerInfo playerinfo = mc.player.connection.getPlayerInfo(uUID);
            if (playerinfo == null) continue;
            this.allPlayers.add(new SimplePlayerEntry(playerinfo));
        }
        for (Map.Entry entry : USERNAME_CACHE.entrySet()) {
            if (onlinePlayers.contains(entry.getKey())) continue;
            this.allPlayers.add(new SimplePlayerEntry((UUID)entry.getKey(), (String)entry.getValue()));
        }
        this.filtered.addAll(this.allPlayers);
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (this.canConsumeInput() && this.suggestion != null) {
            int x = this.getX();
            MultiLineEditBoxWidget.DisplayCache cache = this.getDisplayCache();
            if (cache.lines.length > 0) {
                x += this.font.width(cache.lines[0].contents);
            }
            graphics.drawString(this.font, this.suggestion, x, this.getY(), -8355712, false);
        }
        if (this.getText().isEmpty()) {
            graphics.drawString(this.font, EMPTY_SEARCH, this.getX(), this.getY(), 0, false);
        } else if (this.selectedPlayer != null) {
            this.selectedPlayer.render(graphics, this.getX(), this.getY(), this.width, this.height, partialTicks);
        }
    }

    @Override
    public boolean keyPressed(int key, int alt, int ctrl) {
        if (key == 32) {
            return true;
        }
        if (key == 258 && this.canConsumeInput()) {
            if (!this.fullSuggestion.isEmpty()) {
                this.setText(this.fullSuggestion);
                this.moveCursorToEnd();
                this.clearDisplayCache();
            }
            return true;
        }
        return super.keyPressed(key, alt, ctrl);
    }

    @Override
    public void onValueChanged() {
        this.updateFilteredEntries();
        String newValue = this.getText();
        this.selectedPlayer = null;
        String suggestion = "";
        this.fullSuggestion = "";
        if (!newValue.isEmpty()) {
            for (SimplePlayerEntry entry : this.filtered) {
                String name = entry.getName();
                if (this.fullSuggestion.isEmpty()) {
                    this.fullSuggestion = name;
                    suggestion = name.substring(newValue.length());
                }
                if (!name.equalsIgnoreCase(newValue)) continue;
                this.selectedPlayer = entry;
                break;
            }
        }
        this.setSuggestion(suggestion);
    }

    private void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    @Override
    public void setState(boolean hasItem, boolean packed) {
        super.setState(hasItem, packed);
        this.filtered.clear();
        if (!packed && hasItem) {
            this.setFocused(true);
            this.filtered.addAll(this.allPlayers);
        }
    }

    private void updateFilteredEntries() {
        String filter = this.getText();
        filter = filter == null ? "" : filter.toLowerCase(Locale.ROOT);
        this.filtered.clear();
        String finalFilter = filter;
        this.filtered.addAll(this.allPlayers.stream().filter(s -> s.getName().toLowerCase(Locale.ROOT).startsWith(finalFilter)).toList());
    }

    public void addPlayer(PlayerInfo info) {
        this.allPlayers.removeIf(simplePlayerEntry -> simplePlayerEntry.getId().equals(info.getProfile().getId()));
        this.allPlayers.add(new SimplePlayerEntry(info));
        this.updateFilteredEntries();
        this.onValueChanged();
    }

    public void removePlayer(UUID id) {
        for (SimplePlayerEntry simplePlayerEntry : this.allPlayers) {
            if (!simplePlayerEntry.getId().equals(id)) continue;
            simplePlayerEntry.setOnline(false);
            return;
        }
    }

    public static class SimplePlayerEntry {
        private static final int SKIN_SIZE = 8;
        private final GameProfile profile;
        private boolean isOnline;

        public SimplePlayerEntry(PlayerInfo playerInfo) {
            this.profile = playerInfo.getProfile();
            this.isOnline = true;
        }

        public SimplePlayerEntry(UUID id, String lastName) {
            this.profile = new GameProfile(id, lastName);
            this.isOnline = false;
        }

        public void setOnline(boolean online) {
            this.isOnline = online;
        }

        public UUID getId() {
            return this.profile.getId();
        }

        public String getName() {
            return this.profile.getName();
        }

        public void render(GuiGraphics graphics, int x, int y, int width, int height, float pPartialTicks) {
            int i = x + width - 4;
            float c = this.isOnline ? 1.0f : 0.5f;
            RenderSystem.setShaderColor((float)1.0f, (float)c, (float)c, (float)1.0f);
            PlayerSkin skin = Minecraft.getInstance().getSkinManager().getInsecureSkin(this.profile);
            ResourceLocation resourceLocation = skin.texture();
            graphics.blit(resourceLocation, i, y, 8, 8, 8.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.enableBlend();
            graphics.blit(resourceLocation, i, y, 8, 8, 40.0f, 8.0f, 8, 8, 64, 64);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

