/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.supplementaries.common.block.tiles.StatueBlockTile;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public class StatueEntityModel
extends Model {
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public final ModelPart leftSleeve;
    public final ModelPart rightSleeve;
    public final ModelPart leftPants;
    public final ModelPart rightPants;
    public final ModelPart jacket;
    private final ModelPart cloak;
    private final ModelPart ear;
    public final ModelPart rightArmS;
    public final ModelPart leftArmS;
    public final ModelPart leftSleeveS;
    public final ModelPart rightSleeveS;

    public StatueEntityModel(BlockEntityRendererProvider.Context context) {
        super(RenderType::entityTranslucentCull);
        ModelPart modelPart = context.bakeLayer(ModelLayers.PLAYER);
        this.head = modelPart.getChild("head");
        this.hat = modelPart.getChild("hat");
        this.body = modelPart.getChild("body");
        this.rightArm = modelPart.getChild("right_arm");
        this.leftArm = modelPart.getChild("left_arm");
        this.rightLeg = modelPart.getChild("right_leg");
        this.leftLeg = modelPart.getChild("left_leg");
        this.ear = modelPart.getChild("ear");
        this.cloak = modelPart.getChild("cloak");
        this.leftSleeve = modelPart.getChild("left_sleeve");
        this.rightSleeve = modelPart.getChild("right_sleeve");
        this.leftPants = modelPart.getChild("left_pants");
        this.rightPants = modelPart.getChild("right_pants");
        this.jacket = modelPart.getChild("jacket");
        ModelPart modelPartSlim = context.bakeLayer(ModelLayers.PLAYER_SLIM);
        this.rightArmS = modelPartSlim.getChild("right_arm");
        this.leftArmS = modelPartSlim.getChild("left_arm");
        this.leftSleeveS = modelPartSlim.getChild("left_sleeve");
        this.rightSleeveS = modelPartSlim.getChild("right_sleeve");
    }

    public void renderEars(PoseStack poseStack, VertexConsumer consumer, int light, int overlay) {
        this.ear.copyFrom(this.head);
        this.ear.x = 0.0f;
        this.ear.y = 0.0f;
        this.ear.render(poseStack, consumer, light, overlay);
    }

    public void renderCloak(PoseStack poseStack, VertexConsumer consumer, int light, int overlay, StatueBlockTile tile, float partialTick) {
        BlockPos pos = tile.getBlockPos();
        long gameTime = tile.getLevel() == null ? 0L : tile.getLevel().getGameTime();
        float time = ((float)Math.floorMod((long)pos.getX() * 7L + (long)pos.getY() * 9L + (long)pos.getZ() * 13L + gameTime, 100L) + partialTick) / 100.0f;
        this.cloak.xRot = (-0.04f + 0.01f * Mth.cos((float)((float)Math.PI * 2 * time))) * (float)Math.PI;
        this.cloak.yRot = (float)Math.PI;
        this.cloak.z = 2.0f;
        this.cloak.render(poseStack, consumer, light, overlay);
    }

    public void setupAnim(long ticks, float partialTricks, Direction dir, StatueBlockTile.StatuePose pose, boolean waving, boolean slim) {
        this.rightArmS.visible = slim;
        this.leftArmS.visible = slim;
        this.leftSleeveS.visible = slim;
        this.rightSleeveS.visible = slim;
        this.rightArm.visible = !slim;
        this.leftArm.visible = !slim;
        this.leftSleeve.visible = !slim;
        this.rightSleeve.visible = !slim;
        int d = dir.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? -1 : 1;
        switch (pose) {
            case SWORD: {
                this.leftLeg.xRot = 0.0f;
                this.rightLeg.xRot = 0.0f;
                this.leftArm.xRot = -1.2566371f;
                this.leftArm.yRot = 0.4712389f;
                this.rightArm.xRot = -1.2566371f;
                this.rightArm.yRot = -0.4712389f;
                break;
            }
            case TOOL: {
                this.leftLeg.xRot = 0.0f;
                this.rightLeg.xRot = 0.0f;
                this.leftArm.xRot = -0.9424778f;
                this.leftArm.yRot = 0.4712389f;
                this.rightArm.xRot = -0.9424778f;
                this.rightArm.yRot = -0.4712389f;
                break;
            }
            case HOLDING: 
            case GLOBE: 
            case SEPIA_GLOBE: {
                this.leftLeg.xRot = 0.0f;
                this.rightLeg.xRot = 0.0f;
                this.leftArm.xRot = -0.7853982f;
                this.rightArm.xRot = -0.7853982f;
                this.leftArm.yRot = 0.0f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case STANDING: {
                this.leftLeg.xRot = 0.3926991f * (float)d;
                this.rightLeg.xRot = -0.3926991f * (float)d;
                this.leftArm.xRot = -0.3926991f * (float)d;
                this.rightArm.xRot = 0.3926991f * (float)d;
                this.leftArm.yRot = 0.0f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case CANDLE: {
                this.leftLeg.xRot = 0.0f;
                this.rightLeg.xRot = 0.0f;
                this.leftArm.xRot = -0.3926991f;
                this.rightArm.xRot = -0.3926991f;
                this.leftArm.yRot = 0.0f;
                this.rightArm.yRot = 0.0f;
            }
        }
        if (waving) {
            this.rightArm.yRot = 0.0f;
            this.rightArm.xRot = (float)Math.PI;
            float f2 = ((float)Math.floorMod(ticks, 15L) + partialTricks) / 15.0f;
            this.rightArm.zRot = -0.5f - 0.5f * Mth.sin((float)((float)Math.PI * 2 * f2));
        } else {
            this.rightArm.zRot = 0.0f;
        }
        this.hat.copyFrom(this.head);
        this.leftPants.copyFrom(this.leftLeg);
        this.rightPants.copyFrom(this.rightLeg);
        this.leftSleeve.copyFrom(this.leftArm);
        this.rightSleeve.copyFrom(this.rightArm);
        this.jacket.copyFrom(this.body);
        this.leftArmS.copyFrom(this.leftArm);
        this.rightArmS.copyFrom(this.rightArm);
        this.leftSleeveS.copyFrom(this.leftArm);
        this.rightSleeveS.copyFrom(this.rightArm);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.head.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.hat.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.jacket.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.rightLeg.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.leftLeg.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.leftPants.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.rightPants.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.rightArmS.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.leftArmS.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.leftSleeveS.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.rightSleeveS.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.rightArm.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.leftArm.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.leftSleeve.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.rightSleeve.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }
}

