/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapturedMobCache {
    private static final LoadingCache<UUID, Entity> MOB_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UUID, Entity>(){

        public Entity load(UUID key) {
            return null;
        }
    });
    private static UUID crystalID = UUID.randomUUID();
    private static boolean updateCrystal = false;

    private static void addToCache(Entity e) {
        if (e != null) {
            MOB_CACHE.put((Object)e.getUUID(), (Object)e);
        }
    }

    @Nullable
    public static Entity getOrCreateCachedMob(@NotNull Level level, UUID id, CompoundTag tag) {
        Entity e = (Entity)MOB_CACHE.getIfPresent((Object)id);
        if (e == null) {
            e = CapturedMobCache.createEntityFromNBT(tag, id, level);
            CapturedMobCache.addToCache(e);
        }
        return e;
    }

    @Nullable
    public static Entity createEntityFromNBT(CompoundTag tag, @Nullable UUID id, Level world) {
        if (tag != null && tag.contains("id")) {
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)world, o -> o);
            if (id != null && entity != null) {
                entity.setUUID(id);
                if (entity.hasCustomName()) {
                    entity.setCustomName(entity.getCustomName());
                }
            }
            return entity;
        }
        return null;
    }

    public static void tickCrystal() {
        if (!updateCrystal) {
            return;
        }
        Entity e = (Entity)MOB_CACHE.getIfPresent((Object)crystalID);
        if (e instanceof EndCrystal) {
            EndCrystal c = (EndCrystal)e;
            ++c.time;
            if (e.level() != Minecraft.getInstance().level) {
                crystalID = UUID.randomUUID();
            }
        }
        updateCrystal = false;
    }

    public static EndCrystal getEndCrystal(Level level) {
        updateCrystal = true;
        Entity e = (Entity)MOB_CACHE.getIfPresent((Object)crystalID);
        if (e instanceof EndCrystal) {
            EndCrystal c = (EndCrystal)e;
            return c;
        }
        EndCrystal entity = new EndCrystal(EntityType.END_CRYSTAL, level);
        entity.setShowBottom(false);
        entity.setUUID(crystalID);
        CapturedMobCache.addToCache((Entity)entity);
        return entity;
    }

    public static void clear() {
        MOB_CACHE.invalidateAll();
    }
}

