/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class RotationTrailParticle
extends SimpleAnimatedParticle {
    public static final float SPEED = 11.0f;
    public static final int LIFE = 8;
    private final Vec3 axis;
    private final Vec3 origin;
    private final double radius;
    private float angularVelocity;
    private float currentAngle;
    private float fadeR;
    private float fadeG;
    private float fadeB;
    private static final float AL = 0.6f;

    private RotationTrailParticle(ClientLevel clientWorld, double x, double y, double z, Vec3 center, Vec3 rotationAxis, int ccw, double radius, double angle, SpriteSet sprite) {
        super(clientWorld, x, y, z, sprite, -5.0E-4f);
        this.origin = center;
        this.axis = rotationAxis;
        this.angularVelocity = (float)ccw * 11.0f * ((float)Math.PI / 180);
        this.radius = radius;
        this.currentAngle = (float)angle;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.setSize(0.01f, 0.01f);
        this.quadSize *= 0.625f;
        this.lifetime = 8;
        this.setColor(ClientConfigs.Particles.TURN_INITIAL_COLOR.get());
        this.setFadeColor(ClientConfigs.Particles.TURN_FADE_COLOR.get());
        this.setSpriteFromAge(sprite);
        this.alpha = 0.6f;
        this.hasPhysics = false;
    }

    public void tick() {
        super.tick();
        this.setAlpha(0.6f - (float)this.age / (float)this.lifetime * 0.6f * 0.7f);
    }

    public void setFadeColor(int pRgb) {
        this.fadeR = (float)((pRgb & 0xFF0000) >> 16) / 255.0f;
        this.fadeG = (float)((pRgb & 0xFF00) >> 8) / 255.0f;
        this.fadeB = (float)(pRgb & 0xFF) / 255.0f;
        super.setFadeColor(pRgb);
    }

    public void move(double x, double y, double z) {
        this.rCol += (this.fadeR - this.rCol) * 0.1f;
        this.gCol += (this.fadeG - this.gCol) * 0.1f;
        this.bCol += (this.fadeB - this.bCol) * 0.1f;
        this.currentAngle += this.angularVelocity;
        Vec3 rot = new Vec3(this.radius, 0.0, 0.0).yRot(this.currentAngle);
        Vec3 newPos = MthUtils.changeBasisN((Vec3)this.axis, (Vec3)rot).add(this.origin);
        this.angularVelocity = (float)((double)this.angularVelocity * 0.75);
        super.move(newPos.x - this.x, newPos.y - this.y, newPos.z - this.z);
    }

    public static float increment(float age, int step) {
        return 11.0f * (float)step * (1.0f - ((float)step + 2.0f * (age - 1.0f)) / 16.0f);
    }

    public int getLightColor(float pPartialTick) {
        BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        return this.level.hasChunkAt(blockpos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)blockpos) : 0;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double centerX, double centerY, double centerZ, double direction, double radius, double initialAngle) {
            Vec3 center = new Vec3(centerX, centerY, centerZ);
            int ccw = 1;
            if (direction < 0.0) {
                ccw = -1;
                direction = -direction;
            }
            Direction dir = Direction.from3DDataValue((int)((int)direction));
            float radAngle = (float)(initialAngle * 0.01745329238474369);
            Vec3 axis = MthUtils.V3itoV3((Vec3i)dir.getNormal());
            Vec3 rot = new Vec3(radius, 0.0, 0.0).yRot(radAngle);
            Vec3 newPos = MthUtils.changeBasisN((Vec3)axis, (Vec3)rot).add(center);
            return new RotationTrailParticle(world, newPos.x, newPos.y, newPos.z, center, axis, ccw, radius, radAngle, this.sprites);
        }
    }
}

