/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.entities.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.network.SyncEquippedQuiverPacket;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Stray.class})
public abstract class StrayMixin
extends AbstractSkeleton
implements IQuiverEntity {
    @Unique
    @NotNull
    private ItemStack supplementaries$quiver = ItemStack.EMPTY;
    @Unique
    private float supplementaries$quiverDropChance = 0.6f;

    protected StrayMixin(EntityType<? extends AbstractSkeleton> entityType, Level level) {
        super(entityType, level);
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource damageSource, boolean hitByPlayer) {
        if (!this.supplementaries$quiver.isEmpty()) {
            ItemStack itemStack = this.supplementaries$quiver;
            float dropChance = this.supplementaries$quiverDropChance;
            if (dropChance != 0.0f) {
                boolean alwaysDrop;
                Entity damagingEntity = damageSource.getEntity();
                if (damagingEntity instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)damagingEntity;
                    dropChance = EnchantmentHelper.processEquipmentDropChance((ServerLevel)serverLevel, (LivingEntity)le, (DamageSource)damageSource, (float)dropChance);
                }
                boolean bl = alwaysDrop = dropChance > 1.0f;
                if (!EnchantmentHelper.has((ItemStack)itemStack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) && (hitByPlayer || alwaysDrop) && this.random.nextFloat() < dropChance) {
                    this.spawnAtLocation(itemStack);
                    this.supplementaries$quiver = ItemStack.EMPTY;
                }
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (!this.supplementaries$quiver.isEmpty()) {
            compound.put("Quiver", this.supplementaries$quiver.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)new CompoundTag()));
            compound.putFloat("QuiverDropChance", this.supplementaries$quiverDropChance);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Quiver")) {
            this.supplementaries$setQuiver(ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)compound.getCompound("Quiver")));
            this.supplementaries$quiverDropChance = compound.getFloat("QuiverDropChance");
        }
    }

    @Override
    public ItemStack supplementaries$getQuiver() {
        return this.supplementaries$quiver;
    }

    @Override
    public void supplementaries$setQuiver(ItemStack quiver) {
        this.supplementaries$quiver = quiver;
        if (!this.level().isClientSide) {
            NetworkHelper.sendToAllClientPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new SyncEquippedQuiverPacket(this));
        }
    }

    public boolean wantsToPickUp(ItemStack stack) {
        if (this.supplementaries$quiver.isEmpty() && stack.getItem() == ModRegistry.QUIVER_ITEM.get()) {
            return true;
        }
        return super.wantsToPickUp(stack);
    }

    public ItemStack equipItemIfPossible(ItemStack stack) {
        if (stack.getItem() == ModRegistry.QUIVER_ITEM.get() && this.supplementaries$quiver.isEmpty()) {
            this.supplementaries$setQuiver(stack);
            this.supplementaries$quiverDropChance = 1.0f;
            return stack;
        }
        return super.equipItemIfPossible(stack);
    }
}

