/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.supplementaries.common.items.components.ConfettiColors;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ConfettiDyeRecipe
extends CustomRecipe {
    private final int maxColors;
    private final Ingredient confetti;

    public ConfettiDyeRecipe(CraftingBookCategory category, Ingredient confetti, int maxColors) {
        super(category);
        this.confetti = confetti;
        this.maxColors = maxColors;
    }

    public boolean matches(CraftingInput inv, Level level) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < inv.size(); ++k) {
            ItemStack itemstack = inv.getItem(k);
            if (itemstack.isEmpty()) continue;
            if (this.confetti.test(itemstack)) {
                ++i;
                ConfettiColors existing = (ConfettiColors)itemstack.get(ModComponents.CONFETTI_COLORS.get());
                if (existing != null && existing.size() >= this.maxColors) {
                    return false;
                }
            } else {
                if (ConfettiColors.getRgbColor(itemstack) == null) {
                    return false;
                }
                ++j;
            }
            if (j <= 1 && i <= 1) continue;
            return false;
        }
        return i == 1 && j == 1;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        ItemStack itemstack = ItemStack.EMPTY;
        int dyecolor = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            if (this.confetti.test(stack)) {
                itemstack = stack;
                continue;
            }
            Integer rgb = ConfettiColors.getRgbColor(stack);
            if (rgb == null) continue;
            dyecolor = rgb;
        }
        ItemStack result = itemstack.copyWithCount(1);
        ConfettiColors colorComp = (ConfettiColors)result.getOrDefault(ModComponents.CONFETTI_COLORS.get(), (Object)ConfettiColors.EMPTY);
        result.set(ModComponents.CONFETTI_COLORS.get(), (Object)colorComp.withAddedColor(dyecolor));
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 2;
    }

    public String getGroup() {
        return "confetti_dye";
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.CONFETTI_DYE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ConfettiDyeRecipe> {
        private static final MapCodec<ConfettiDyeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(CraftingRecipe::category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.confetti), (App)Codec.INT.fieldOf("max_colors").orElse((Object)4).forGetter(recipe -> recipe.maxColors)).apply((Applicative)instance, ConfettiDyeRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, ConfettiDyeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)CraftingBookCategory.STREAM_CODEC, CraftingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.confetti, (StreamCodec)ByteBufCodecs.INT, recipe -> recipe.maxColors, ConfettiDyeRecipe::new);

        public MapCodec<ConfettiDyeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConfettiDyeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

