/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.DummySprite;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.SignPostBlockTileRenderer;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SignPostBlockBakedModel
implements CustomBakedModel {
    private final BlockModelShaper blockModelShaper = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        BlockState mimic = (BlockState)data.get(ModBlockProperties.MIMIC);
        Boolean isFramed = (Boolean)data.get(ModBlockProperties.FRAMED);
        SignPostBlockTile.Sign up = (SignPostBlockTile.Sign)data.get(ModBlockProperties.SIGN_UP);
        SignPostBlockTile.Sign down = (SignPostBlockTile.Sign)data.get(ModBlockProperties.SIGN_DOWN);
        Float zOffset = (Float)data.get(ModBlockProperties.RENDER_OFFSET);
        boolean framed = CompatHandler.FRAMEDBLOCKS && isFramed != null && isFramed != false;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (mimic != null && !mimic.isAir()) {
            if (framed) {
                data2 = FramedBlocksCompat.getModelData(mimic);
                mimic = FramedBlocksCompat.getFramedFence();
            } else {
                data2 = ExtraModelData.EMPTY;
            }
            BakedModel model = this.blockModelShaper.getBlockModel(mimic);
            quads.addAll(model.getQuads(mimic, side, rand));
        }
        if (up != null && down != null) {
            try (BakedQuadBuilder builder = BakedQuadBuilder.create((TextureAtlasSprite)DummySprite.INSTANCE, quads::add);){
                builder.setAutoDirection();
                builder.setAmbientOcclusion(false);
                SignPostBlockTileRenderer.renderSigns(new PoseStack(), (VertexConsumer)builder, 0, 0, up, down, zOffset);
            }
            catch (Exception e) {
                Supplementaries.error();
            }
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        SignPostBlockTile.Sign sign;
        BlockState mimic = (BlockState)data.get(SignPostBlockTile.MIMIC_KEY);
        if (mimic != null && !mimic.isAir()) {
            BakedModel model = this.blockModelShaper.getBlockModel(mimic);
            try {
                return model.getParticleIcon();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((sign = (SignPostBlockTile.Sign)data.get(SignPostBlockTile.SIGN_UP_KEY)) == null || !sign.active()) {
            sign = (SignPostBlockTile.Sign)data.get(SignPostBlockTile.SIGN_DOWN_KEY);
        }
        if (sign != null && sign.active()) {
            BlockState planks = sign.woodType().planks.defaultBlockState();
            BakedModel model = this.blockModelShaper.getBlockModel(planks);
            try {
                return model.getParticleIcon();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.blockModelShaper.getBlockModel(Blocks.OAK_PLANKS.defaultBlockState()).getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

