/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadsTransformer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public class FaucetBakedModel
implements CustomBakedModel {
    private static final boolean SINGLE_PASS = PlatHelper.getPlatform().isFabric();
    private final BakedModel model;
    private final BakedModel liquid;

    public FaucetBakedModel(BakedModel model, BakedModel liquid, ModelState rotation) {
        this.model = model;
        this.liquid = liquid;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (SINGLE_PASS || renderType == RenderType.translucent()) {
            List liquidQuads;
            SoftFluid fluid;
            ResourceKey fluidKey = (ResourceKey)data.get(ModBlockProperties.FLUID);
            ClientLevel level = Minecraft.getInstance().level;
            if (fluidKey != null && level != null && (fluid = (SoftFluid)SoftFluidRegistry.get((RegistryAccess)level.registryAccess()).get(fluidKey)) != null && !(liquidQuads = this.liquid.getQuads(state, side, rand)).isEmpty()) {
                int color = ColorUtils.swapFormat((int)((Integer)data.get(ModBlockProperties.FLUID_COLOR))) | 0xFF000000;
                int col2 = color & 0xFFFFFF | 0x28000000;
                TextureAtlasSprite sprite = ModMaterials.get(fluid.getFlowingTexture()).sprite();
                BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingSprite(sprite).applyingAmbientOcclusion(false).applyingColor(i -> {
                    if (i == 1 || i == 2) {
                        return col2;
                    }
                    return color;
                }).applyingEmissivity(fluid.getEmissivity());
                quads.addAll(transformer.transformAll(liquidQuads));
            }
            if (!SINGLE_PASS) {
                return quads;
            }
        }
        if (RenderType.cutout() == renderType) {
            quads.addAll(this.model.getQuads(state, side, rand));
        }
        return quads;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData extraModelData) {
        return this.model.getParticleIcon();
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

