/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.util.BlockChangeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class ChangeStorage {
    private static int storageIDs = 0;
    private final int id;
    private final Map<BlockPos, BlockChangeData> blocks = new HashMap<BlockPos, BlockChangeData>();
    private final List<CompoundTag> removedEntities = new ArrayList<CompoundTag>();
    private final List<Entity> addedEntities = new ArrayList<Entity>();
    private final Component operation;
    private Iterator<Map.Entry<BlockPos, BlockChangeData>> iterator = null;
    private final UUID player;

    public ChangeStorage(Component operation, UUID player) {
        this.player = player;
        this.id = storageIDs++;
        this.operation = operation;
    }

    public void addPreviousDataFor(BlockPos place, Level world) {
        this.blocks.computeIfAbsent(place, p -> new BlockChangeData()).withPreState(world.getBlockState(place)).withPreTE(world.getBlockEntity(place));
    }

    public void addPostDataFor(BlockPos place, Level world) {
        this.blocks.computeIfAbsent(place, p -> new BlockChangeData()).withPostState(world.getBlockState(place)).withPostTE(world.getBlockEntity(place));
    }

    public void addEntities(List<Entity> list, HolderLookup.Provider provider) {
        list.stream().map(entity -> {
            CompoundTag tag = new CompoundTag();
            entity.save(tag);
            return tag;
        }).forEach(this.removedEntities::add);
    }

    public void addToBeKilledEntity(Entity entity) {
        this.addedEntities.add(entity);
    }

    public boolean undo(Level world, @Nullable ChangeStorage undoStorage) {
        if (this.iterator == null) {
            this.iterator = this.blocks.entrySet().iterator();
        }
        int count = 0;
        while (this.iterator.hasNext()) {
            Map.Entry<BlockPos, BlockChangeData> entry = this.iterator.next();
            if (world.getBlockState(entry.getKey()).getBlock() != entry.getValue().getPostState().getBlock() || entry.getValue().getPostTE() != world.getBlockEntity(entry.getKey())) continue;
            if (undoStorage != null) {
                undoStorage.addPreviousDataFor(entry.getKey(), world);
            }
            world.setBlock(entry.getKey(), Blocks.COBBLESTONE.defaultBlockState(), 2);
            world.setBlock(entry.getKey(), entry.getValue().getPreState(), 3);
            if (entry.getValue().getPreTE() != null) {
                world.setBlockEntity(entry.getValue().getPreTE());
            }
            world.markAndNotifyBlock(entry.getKey(), world.getChunkAt(entry.getKey()), entry.getValue().getPreState(), entry.getValue().getPreState(), 2, 512);
            if (undoStorage != null) {
                undoStorage.addPostDataFor(entry.getKey(), world);
            }
            if (++count < (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).maxOperationsPerTick.get()) continue;
            return false;
        }
        for (CompoundTag data : this.removedEntities) {
            Entity entity;
            Optional type = EntityType.by((CompoundTag)data);
            if (!type.isPresent() || (entity = ((EntityType)type.get()).create(world)) == null) continue;
            entity.load(data);
            world.addFreshEntity(entity);
            if (undoStorage == null) continue;
            undoStorage.addedEntities.add(entity);
        }
        this.addedEntities.forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
        if (undoStorage != null) {
            Manager.addToUndoRedoCache(undoStorage);
        }
        return true;
    }

    public boolean redo(Level world) {
        int count = 0;
        if (this.iterator == null) {
            this.iterator = this.blocks.entrySet().iterator();
        }
        while (this.iterator.hasNext()) {
            Map.Entry<BlockPos, BlockChangeData> entry = this.iterator.next();
            if (world.getBlockState(entry.getKey()).getBlock() != entry.getValue().getPreState().getBlock()) continue;
            world.setBlock(entry.getKey(), Blocks.COBBLESTONE.defaultBlockState(), 2);
            world.setBlock(entry.getKey(), entry.getValue().getPostState(), 3);
            if (entry.getValue().getPostTE() != null) {
                world.setBlockEntity(entry.getValue().getPostTE());
            }
            world.markAndNotifyBlock(entry.getKey(), world.getChunkAt(entry.getKey()), entry.getValue().getPostState(), entry.getValue().getPostState(), 2, 512);
            if (++count < (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).maxOperationsPerTick.get()) continue;
            return false;
        }
        return true;
    }

    public Component getOperation() {
        return this.operation;
    }

    public void resetUnRedo() {
        this.iterator = null;
    }

    public boolean isDone() {
        return this.iterator == null || !this.iterator.hasNext();
    }

    public int getID() {
        return this.id;
    }

    public UUID getPlayerID() {
        return this.player;
    }
}

