/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage;

import com.ldtteam.structurize.blueprints.v1.Blueprint;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;

public class ServerFutureProcessor {
    private static final Queue<BlueprintProcessingData> blueprintConsumerQueue = new LinkedList<BlueprintProcessingData>();
    private static final Queue<BlueprintDataProcessingData> blueprintDataConsumerQueue = new LinkedList<BlueprintDataProcessingData>();
    private static final Queue<BlueprintListProcessingData> blueprintListConsumerQueue = new LinkedList<BlueprintListProcessingData>();

    public static void queueBlueprint(@NotNull BlueprintProcessingData processingData) {
        blueprintConsumerQueue.add(processingData);
    }

    public static void queueBlueprintList(@NotNull BlueprintListProcessingData processingData) {
        blueprintListConsumerQueue.add(processingData);
    }

    public static void queueBlueprintData(@NotNull BlueprintDataProcessingData processingData) {
        blueprintDataConsumerQueue.add(processingData);
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Record data;
        if (!blueprintConsumerQueue.isEmpty() && ServerFutureProcessor.blueprintConsumerQueue.peek().level == event.getLevel() && ServerFutureProcessor.blueprintConsumerQueue.peek().blueprintFuture.isDone()) {
            data = blueprintConsumerQueue.poll();
            try {
                data.consumer.accept(data.blueprintFuture.get());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (!blueprintDataConsumerQueue.isEmpty() && ServerFutureProcessor.blueprintDataConsumerQueue.peek().level == event.getLevel() && ServerFutureProcessor.blueprintDataConsumerQueue.peek().blueprintDataFuture.isDone()) {
            data = blueprintDataConsumerQueue.poll();
            try {
                ((BlueprintDataProcessingData)data).consumer.accept(((BlueprintDataProcessingData)data).blueprintDataFuture.get());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        if (!blueprintListConsumerQueue.isEmpty() && ServerFutureProcessor.blueprintListConsumerQueue.peek().level == event.getLevel() && ServerFutureProcessor.blueprintListConsumerQueue.peek().blueprintFuture.isDone()) {
            data = blueprintListConsumerQueue.poll();
            try {
                ((BlueprintListProcessingData)data).consumer.accept(((BlueprintListProcessingData)data).blueprintFuture.get());
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public record BlueprintProcessingData(Future<Blueprint> blueprintFuture, Level level, Consumer<Blueprint> consumer) {
    }

    public record BlueprintDataProcessingData(Future<byte[]> blueprintDataFuture, Level level, Consumer<byte[]> consumer) {
    }

    public record BlueprintListProcessingData(Future<List<Blueprint>> blueprintFuture, Level level, Consumer<List<Blueprint>> consumer) {
    }
}

