/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.handlers.placement;

import com.ldtteam.structurize.api.IRotatableBlockEntity;
import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blocks.schematic.BlockFluidSubstitution;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.handlers.placement.DoBlockPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.tag.ModTags;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public final class PlacementHandlers {
    public static final List<IPlacementHandler> handlers = new ArrayList<IPlacementHandler>();

    public static void add(IPlacementHandler handler, Class<?> override) {
        for (int i = 0; i < handlers.size(); ++i) {
            if (!override.isInstance(handlers.get(i))) continue;
            handlers.set(i, handler);
            return;
        }
        PlacementHandlers.add(handler);
    }

    public static void add(IPlacementHandler handler) {
        handlers.add(1, handler);
    }

    public static IPlacementHandler getHandler(Level world, BlockPos worldPos, BlockState newState) {
        for (IPlacementHandler placementHandler : handlers) {
            if (!placementHandler.canHandle(world, worldPos, newState)) continue;
            return placementHandler;
        }
        Log.getLogger().error("Unable to find any PlacementHandler for {}; this should be impossible.", (Object)newState.toString());
        return new GeneralBlockPlacementHandler();
    }

    private PlacementHandlers() {
    }

    public static void handleTileEntityPlacement(CompoundTag tileEntityData, Level world, BlockPos pos, RotationMirror settings) {
        BlockEntity newTile;
        if (tileEntityData != null && (newTile = BlockEntity.loadStatic((BlockPos)pos, (BlockState)world.getBlockState(pos), (CompoundTag)tileEntityData, (HolderLookup.Provider)world.registryAccess())) != null) {
            BlockEntity worldBlockEntity;
            if (newTile instanceof IRotatableBlockEntity) {
                IRotatableBlockEntity rotatable = (IRotatableBlockEntity)newTile;
                rotatable.rotateAndMirror(settings);
            }
            if ((worldBlockEntity = world.getBlockEntity(pos)) != null) {
                worldBlockEntity.loadWithComponents(newTile.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess()), (HolderLookup.Provider)world.registryAccess());
                worldBlockEntity.setChanged();
            } else {
                world.setBlockEntity(newTile);
            }
            world.getBlockState(pos).mirror(settings.mirror());
            world.getBlockState(pos).rotate((LevelAccessor)world, pos, settings.rotation());
        }
    }

    public static List<ItemStack> getRequiredItemsForState(Level world, BlockPos pos, BlockState state, CompoundTag data, boolean complete) {
        IPlacementHandler placementHandler = PlacementHandlers.getHandler(world, pos, state);
        return placementHandler.getRequiredItems(world, pos, state, data, complete);
    }

    public static List<ItemStack> getItemsFromTileEntity(CompoundTag tileEntityData, BlockState blockState, Level provider) {
        if (tileEntityData == null) {
            return Collections.emptyList();
        }
        try {
            return ItemStackUtils.getItemStacksOfTileEntity(tileEntityData, blockState, provider);
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    static {
        handlers.add(new AirPlacementHandler());
        handlers.add(new BlackListedBlockPlacementHandler());
        handlers.add(new FluidSubstitutionPlacementHandler());
        handlers.add(new FirePlacementHandler());
        handlers.add(new BlockGrassPathPlacementHandler());
        handlers.add(new GrassPlacementHandler());
        handlers.add(new DoorPlacementHandler());
        handlers.add(new BedPlacementHandler());
        handlers.add(new DoublePlantPlacementHandler());
        handlers.add(new SpecialBlockPlacementAttemptHandler());
        handlers.add(new FlowerPotPlacementHandler());
        handlers.add(new StairBlockPlacementHandler());
        handlers.add(new HopperClientLagPlacementHandler());
        handlers.add(new ContainerPlacementHandler());
        handlers.add(new DripStoneBlockPlacementHandler());
        handlers.add(new FallingBlockPlacementHandler());
        handlers.add(new BannerPlacementHandler());
        handlers.add(new DoBlockPlacementHandler());
        handlers.add(new GeneralBlockPlacementHandler());
    }

    public static class GeneralBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return true;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
            if (world.getBlockState(pos).equals(blockState)) {
                world.removeBlock(pos, false);
                world.setBlock(pos, blockState, 3);
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
                }
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.setBlock(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, blockState, world));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class AirPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof AirBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.isEmptyBlock(pos)) {
                List entityList = world.getEntitiesOfClass(Entity.class, new AABB(pos), entity -> !(entity instanceof LivingEntity) && !(entity instanceof ItemEntity));
                if (!entityList.isEmpty()) {
                    for (Entity entity2 : entityList) {
                        entity2.remove(Entity.RemovalReason.KILLED);
                    }
                }
                world.removeBlock(pos, false);
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class BlackListedBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.is(ModTags.BLUEPRINT_BLACKLIST);
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            return Collections.emptyList();
        }
    }

    public static class FluidSubstitutionPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof BlockFluidSubstitution;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (complete) {
                items.add(new ItemStack((ItemLike)blockState.getBlock()));
            } else if (BlockUtils.getFluidForDimension(world).getBlock() == Blocks.LAVA) {
                items.add(new ItemStack((ItemLike)Items.LAVA_BUCKET));
            }
            return items;
        }

        @Override
        public void handleRemoval(IStructureHandler handler, Level world, BlockPos pos, CompoundTag tileEntityData) {
            BlockState state = world.getBlockState(pos);
            if (!state.hasProperty((Property)BlockStateProperties.WATERLOGGED) || ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() || BlockUtils.getFluidForDimension(world).getBlock() != Blocks.WATER) {
                this.handleRemoval(handler, world, pos);
            }
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (complete) {
                world.setBlock(pos, ((BlockFluidSubstitution)((Object)ModBlocks.blockFluidSubstitution.get())).defaultBlockState(), 3);
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (world.getBlockState(pos).hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                world.setBlock(pos, (BlockState)world.getBlockState(pos).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            } else {
                world.setBlock(pos, BlockUtils.getFluidForDimension(world), 3);
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
    }

    public static class FirePlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof FireBlock;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(new ItemStack((ItemLike)Items.FLINT_AND_STEEL, 1));
            return itemList;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            world.setBlock(pos, blockState, 3);
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
    }

    public static class BlockGrassPathPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof DirtPathBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.setBlock(pos, Blocks.DIRT_PATH.defaultBlockState(), 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            if (complete) {
                return Collections.singletonList(new ItemStack((ItemLike)blockState.getBlock()));
            }
            return Collections.singletonList(new ItemStack((ItemLike)Blocks.DIRT));
        }
    }

    public static class GrassPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() == Blocks.GRASS_BLOCK || blockState.getBlock() != Blocks.DIRT && blockState.is(BlockTags.DIRT) && Blocks.DIRT == blockState.getBlock();
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (!world.setBlock(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            if (complete) {
                return Collections.singletonList(new ItemStack((ItemLike)blockState.getBlock()));
            }
            return Collections.singletonList(new ItemStack((ItemLike)Blocks.DIRT));
        }
    }

    public static class DoorPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof DoorBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (((DoubleBlockHalf)blockState.getValue((Property)DoorBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.setBlock(pos, (BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
                world.setBlock(pos.above(), (BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            if (((DoubleBlockHalf)blockState.getValue((Property)DoorBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
                itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            }
            return itemList;
        }
    }

    public static class BedPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof BedBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
            if (blockState.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
                Direction facing = (Direction)blockState.getValue((Property)BedBlock.FACING);
                world.setBlock(pos.relative(facing.getOpposite()), (BlockState)blockState.setValue((Property)BedBlock.PART, (Comparable)BedPart.FOOT), 3);
                world.setBlock(pos, (BlockState)blockState.setValue((Property)BedBlock.PART, (Comparable)BedPart.HEAD), 3);
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos.relative(facing.getOpposite()), settings);
                }
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            if (blockState.getValue((Property)BedBlock.PART) == BedPart.HEAD) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                list.add(new ItemStack((ItemLike)blockState.getBlock(), 1));
                return list;
            }
            return Collections.emptyList();
        }
    }

    public static class DoublePlantPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof DoublePlantBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            if (((DoubleBlockHalf)blockState.getValue((Property)DoublePlantBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.setBlock(pos, (BlockState)blockState.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
                world.setBlock(pos.above(), (BlockState)blockState.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            return itemList;
        }
    }

    public static class SpecialBlockPlacementAttemptHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof EndPortalBlock || blockState.getBlock() instanceof SpawnerBlock || blockState.getBlock() instanceof DragonEggBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            return new ArrayList<ItemStack>();
        }
    }

    public static class FlowerPotPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof FlowerPotBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
            if (world.getBlockState(pos).getBlock() == blockState.getBlock()) {
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.setBlock(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.add(new ItemStack((ItemLike)((FlowerPotBlock)blockState.getBlock()).getPotted()));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class StairBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof StairBlock && !(blockState.getBlock() instanceof EntityBlock) && world.getBlockState(pos).getBlock() instanceof StairBlock && world.getBlockState(pos).getValue((Property)StairBlock.FACING) == blockState.getValue((Property)StairBlock.FACING) && world.getBlockState(pos).getValue((Property)StairBlock.HALF) == blockState.getValue((Property)StairBlock.HALF) && blockState.getBlock() == world.getBlockState(pos).getBlock();
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            if (complete) {
                return Collections.singletonList(new ItemStack((ItemLike)blockState.getBlock()));
            }
            return new ArrayList<ItemStack>();
        }
    }

    public static class HopperClientLagPlacementHandler
    extends ContainerPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof HopperBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
            boolean flag = !world.hasNeighborSignal(pos);
            return super.handle(world, pos, flag != (Boolean)blockState.getValue((Property)HopperBlock.ENABLED) ? (BlockState)blockState.setValue((Property)HopperBlock.ENABLED, (Comparable)Boolean.valueOf(flag)) : blockState, tileEntityData, complete, centerPos);
        }
    }

    public static class ContainerPlacementHandler
    implements IPlacementHandler {
        public static Set<Block> CONTAINERS = Set.of();

        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return CONTAINERS.contains(blockState.getBlock());
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
            if (!world.setBlock(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            try {
                ItemStackUtils.getItemStacksOfTileEntity(tileEntityData, blockState, world);
            }
            catch (Exception ex) {
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.addAll(PlacementHandlers.getItemsFromTileEntity(tileEntityData, blockState, world));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class DripStoneBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() == Blocks.POINTED_DRIPSTONE;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Blueprint blueprint, Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
            if (world.getBlockState(pos).equals(blockState)) {
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (blockState.getValue((Property)PointedDripstoneBlock.THICKNESS) != DripstoneThickness.TIP && blockState.getValue((Property)PointedDripstoneBlock.THICKNESS) != DripstoneThickness.TIP_MERGE) {
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            Direction dir = ((Direction)blockState.getValue((Property)PointedDripstoneBlock.TIP_DIRECTION)).getOpposite();
            if (blockState.getValue((Property)PointedDripstoneBlock.THICKNESS) == DripstoneThickness.TIP_MERGE) {
                DripStoneBlockPlacementHandler.placeDripStoneInDir(dir.getOpposite(), blueprint, pos.subtract((Vec3i)centerPos).offset((Vec3i)blueprint.getPrimaryBlockOffset()), pos, blockState, world);
                DripStoneBlockPlacementHandler.placeDripStoneInDir(dir, blueprint, pos.subtract((Vec3i)centerPos).offset((Vec3i)blueprint.getPrimaryBlockOffset()), pos, blockState, world);
                world.setBlock(pos, blockState, 3);
                return IPlacementHandler.ActionProcessingResult.SUCCESS;
            }
            DripStoneBlockPlacementHandler.placeDripStoneInDir(dir, blueprint, pos.subtract((Vec3i)centerPos).offset((Vec3i)blueprint.getPrimaryBlockOffset()), pos, blockState, world);
            world.setBlock(pos, blockState, 3);
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        private static void placeDripStoneInDir(Direction dir, Blueprint blueprint, BlockPos blueprintPos, BlockPos worldPos, BlockState blockState, Level world) {
            try {
                BlockState firstState = blueprint.getBlockState(blueprintPos.relative(dir, 1));
                if (firstState != null && firstState.getBlock() == Blocks.POINTED_DRIPSTONE) {
                    BlockState secondState = blueprint.getBlockState(blueprintPos.relative(dir, 2));
                    if (secondState != null && secondState.getBlock() == Blocks.POINTED_DRIPSTONE) {
                        world.setBlock(worldPos.relative(dir, 2), secondState, 3);
                    }
                    world.setBlock(worldPos.relative(dir, 1), firstState, 3);
                }
            }
            catch (Exception ex) {
                Log.getLogger().error("Problem placing dripstone. Dripstone might extend outside of the schematic.");
            }
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, blockState, world));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }

    public static class FallingBlockPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof FallingBlock || blockState.getBlock() instanceof Fallable;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, blockState, world));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            if (!BlockUtils.isAnySolid(world.getBlockState(pos.below()))) {
                BlockPos posBelow = pos;
                BlockState supportBlockState = Blocks.DIRT instanceof Fallable ? Blocks.STONE.defaultBlockState() : Blocks.DIRT.defaultBlockState();
                for (int i = 0; i < 10; ++i) {
                    boolean isFirstTest;
                    BlockState possibleSupport = BlockUtils.getWorldgenBlock(world, posBelow = posBelow.below(), arg_0 -> FallingBlockPlacementHandler.lambda$getRequiredItems$0(isFirstTest = i == 0, blockState, arg_0));
                    if (possibleSupport == null || !BlockUtils.canBlockFloatInAir(possibleSupport) || this.canHandle(world, posBelow, possibleSupport)) continue;
                    supportBlockState = possibleSupport;
                    break;
                }
                if (this.canHandle(world, pos, supportBlockState)) {
                    Log.getLogger().warn("Unable to use: " + String.valueOf(supportBlockState) + " as support for a falling block, it is either a falling black itself or made fallable");
                } else {
                    itemList.addAll(PlacementHandlers.getRequiredItemsForState(world, pos, supportBlockState, tileEntityData, complete));
                }
            }
            return itemList;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
            if (world.getBlockState(pos).equals(blockState)) {
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!BlockUtils.isAnySolid(world.getBlockState(pos.below()))) {
                BlockPos posBelow = pos;
                BlockState supportBlockState = Blocks.DIRT.defaultBlockState();
                for (int i = 0; i < 10; ++i) {
                    boolean isFirstTest;
                    BlockState possibleSupport = BlockUtils.getWorldgenBlock(world, posBelow = posBelow.below(), arg_0 -> FallingBlockPlacementHandler.lambda$handle$1(isFirstTest = i == 0, blockState, arg_0));
                    if (possibleSupport == null || !BlockUtils.canBlockFloatInAir(possibleSupport)) continue;
                    supportBlockState = possibleSupport;
                    break;
                }
                world.setBlock(pos.below(), supportBlockState, 3);
            }
            if (!world.setBlock(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        private static /* synthetic */ BlockState lambda$handle$1(boolean isFirstTest, BlockState blockState, BlockPos bp) {
            return isFirstTest ? blockState : null;
        }

        private static /* synthetic */ BlockState lambda$getRequiredItems$0(boolean isFirstTest, BlockState blockState, BlockPos bp) {
            return isFirstTest ? blockState : null;
        }
    }

    public static class BannerPlacementHandler
    implements IPlacementHandler {
        @Override
        public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
            return blockState.getBlock() instanceof BannerBlock;
        }

        @Override
        public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
            if (world.getBlockState(pos).equals(blockState)) {
                if (tileEntityData != null) {
                    PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
                }
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            if (!world.setBlock(pos, blockState, 3)) {
                return IPlacementHandler.ActionProcessingResult.DENY;
            }
            if (tileEntityData != null) {
                PlacementHandlers.handleTileEntityPlacement(tileEntityData, world, pos, settings);
                blockState.getBlock().setPlacedBy(world, pos, blockState, null, BlockUtils.getItemStackFromBlockState(blockState));
            }
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }

        @Override
        public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(PlacementHandlers.getItemsFromTileEntity(tileEntityData, blockState, world));
            itemList.add(BlockUtils.getItemStackFromBlockState(blockState));
            itemList.removeIf(ItemStackUtils::isEmpty);
            return itemList;
        }
    }
}

