/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.operations;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.operations.BaseOperation;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class RemoveEntityOperation
extends BaseOperation {
    private final BlockPos startPos;
    private final BlockPos endPos;
    private final EntityType<?> entityType;

    public RemoveEntityOperation(Player player, BlockPos startPos, BlockPos endPos, EntityType<?> entityType) {
        super(new ChangeStorage((Component)Component.translatable((String)"com.ldtteam.structurize.remove_entity", (Object[])new Object[]{entityType.getDescription()}), player != null ? player.getUUID() : UUID.randomUUID()));
        this.startPos = startPos;
        this.endPos = endPos;
        this.entityType = entityType;
    }

    @Override
    public boolean apply(ServerLevel world) {
        List list = world.getEntitiesOfClass(Entity.class, AABB.encapsulatingFullBlocks((BlockPos)this.startPos, (BlockPos)this.endPos));
        this.storage.addEntities(list, (HolderLookup.Provider)world.registryAccess());
        int count = 0;
        for (Entity entity : list) {
            if (!entity.getType().equals(this.entityType)) continue;
            entity.remove(Entity.RemovalReason.DISCARDED);
            if (++count < (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).maxOperationsPerTick.get()) continue;
            return false;
        }
        return true;
    }
}

