/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.operations;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.network.messages.UpdateClientRender;
import com.ldtteam.structurize.operations.BaseOperation;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;

public abstract class AreaOperation
extends BaseOperation {
    protected final Player player;
    protected BlockPos.MutableBlockPos startPos = new BlockPos.MutableBlockPos();
    protected BlockPos.MutableBlockPos endPos = new BlockPos.MutableBlockPos();
    private List<BlockPos> workPosList = new ArrayList<BlockPos>();
    private int currentListIndex = 0;

    protected AreaOperation(Component storageText, Player player, BlockPos startPos, BlockPos endPos) {
        super(new ChangeStorage(storageText, player != null ? player.getUUID() : UUID.randomUUID()));
        this.player = player;
        this.startPos = new BlockPos.MutableBlockPos(Math.min(startPos.getX(), endPos.getX()), Math.min(startPos.getY(), endPos.getY()), Math.min(startPos.getZ(), endPos.getZ()));
        this.endPos = new BlockPos.MutableBlockPos(Math.max(startPos.getX(), endPos.getX()), Math.max(startPos.getY(), endPos.getY()), Math.max(startPos.getZ(), endPos.getZ()));
        for (int x = startPos.getX(); x <= endPos.getX(); ++x) {
            for (int z = startPos.getZ(); z <= endPos.getZ(); ++z) {
                for (int y = startPos.getY(); y <= endPos.getY(); ++y) {
                    this.workPosList.add(new BlockPos(x, y, z));
                }
            }
        }
    }

    protected AreaOperation(Component storageText, Player player, List<BlockPos> workPosList) {
        super(new ChangeStorage(storageText, player != null ? player.getUUID() : UUID.randomUUID()));
        this.player = player;
        this.workPosList = workPosList;
    }

    @Override
    public final boolean apply(ServerLevel world) {
        if (this.player != null && this.player.level().dimension() != world.dimension()) {
            return false;
        }
        int count = 0;
        int i = this.currentListIndex;
        while (i < this.workPosList.size()) {
            BlockPos currentPos = this.workPosList.get(i);
            this.currentListIndex = i++;
            this.apply(world, currentPos);
            this.startPos.set(Math.min(this.startPos.getX(), currentPos.getX()), Math.min(this.startPos.getY(), currentPos.getY()), Math.min(this.startPos.getZ(), currentPos.getZ()));
            this.endPos.set(Math.max(this.endPos.getX(), currentPos.getX()), Math.max(this.endPos.getY(), currentPos.getY()), Math.max(this.endPos.getZ(), currentPos.getZ()));
            if (++count < (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).maxOperationsPerTick.get()) continue;
            return false;
        }
        new UpdateClientRender((BlockPos)this.startPos, (BlockPos)this.endPos).sendToAllClients();
        return true;
    }

    protected abstract void apply(ServerLevel var1, BlockPos var2);
}

