/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SyncPreviewCacheToClient
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"structurize", (String)"sync_preview_cache_to_client", SyncPreviewCacheToClient::new);
    public static final String SHARED_PREFIX = "shared:";
    private final BlueprintPreviewData previewData;
    private final UUID playerUUID;

    protected SyncPreviewCacheToClient(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.previewData = new BlueprintPreviewData(buf, false);
        this.playerUUID = buf.readUUID();
    }

    public SyncPreviewCacheToClient(BlueprintPreviewData previewData, UUID playerUUID) {
        super(TYPE);
        this.previewData = previewData;
        this.playerUUID = playerUUID;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        this.previewData.writeToBuf((FriendlyByteBuf)buf);
        buf.writeUUID(this.playerUUID);
    }

    protected void onExecute(IPayloadContext context, Player player) {
        String uuid = SHARED_PREFIX + this.playerUUID.toString();
        if (this.previewData.isEmpty()) {
            if (RenderingCache.hasBlueprint(uuid)) {
                RenderingCache.removeBlueprint(uuid);
            }
        } else {
            RenderingCache.queue(uuid, this.previewData);
        }
    }
}

