/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.client.gui.util.ItemPositionsStorage;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.ReplaceBlockOperation;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ReplaceBlockMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"replace_block", ReplaceBlockMessage::new);
    private final ItemPositionsStorage toReplace;
    private final ItemStack blockTo;
    private final int pct;

    protected ReplaceBlockMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.blockTo = ItemStackUtils.deserializeFromBuffer(buf);
        this.pct = buf.readInt();
        this.toReplace = new ItemPositionsStorage(buf);
    }

    public ReplaceBlockMessage(ItemPositionsStorage toReplace, ItemStack blockTo, int pct) {
        super(TYPE);
        this.toReplace = toReplace;
        this.blockTo = blockTo;
        this.pct = pct;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        ItemStackUtils.serializeToBuffer(this.blockTo, buf);
        buf.writeInt(this.pct);
        this.toReplace.serialize(buf);
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        if (!player.isCreative()) {
            return;
        }
        Manager.addToQueue(new ReplaceBlockOperation((Player)player, this.toReplace, this.blockTo, this.pct));
    }
}

