/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.blockui.BOScreen;
import com.ldtteam.structurize.api.IScrollableItem;
import com.ldtteam.structurize.api.ISpecialBlockPickItem;
import com.ldtteam.structurize.client.BlueprintHandler;
import com.ldtteam.structurize.client.ModKeyMappings;
import com.ldtteam.structurize.client.gui.WindowExtendedBuildTool;
import com.ldtteam.structurize.event.WorldRenderContext;
import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.network.messages.ItemMiddleMouseMessage;
import com.ldtteam.structurize.network.messages.ScanToolTeleportMessage;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.WorldRenderMacros;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.NotNull;

public class ClientEventSubscriber {
    @SubscribeEvent
    public static void renderWorldLastEvent(RenderGuiLayerEvent.Pre event) {
        if ((event.getName().equals((Object)VanillaGuiLayers.PLAYER_HEALTH) || event.getName().equals((Object)VanillaGuiLayers.FOOD_LEVEL)) && Minecraft.getInstance().screen instanceof BOScreen && ((BOScreen)Minecraft.getInstance().screen).getWindow() instanceof WindowExtendedBuildTool) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderLevelStageEvent event) {
        WorldRenderContext.INSTANCE.renderWorldLastEvent(event);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void finishBuffers(RenderLevelStageEvent event) {
        WorldRenderMacros.RenderTypes.finishBuffer(event);
    }

    @SubscribeEvent
    public static void onClientTickEvent(ClientTickEvent.Post event) {
        ItemScanTool tool;
        Item item;
        Minecraft mc = Minecraft.getInstance();
        mc.getProfiler().push("structurize");
        if (mc.level != null && mc.level.getGameTime() % 300L == 0L) {
            mc.getProfiler().push("blueprint_manager_tick");
            BlueprintHandler.getInstance().cleanCache();
            mc.getProfiler().pop();
        }
        if (((KeyMapping)ModKeyMappings.TELEPORT.get()).consumeClick() && mc.level != null && mc.player != null && (item = mc.player.getMainHandItem().getItem()) instanceof ItemScanTool && (tool = (ItemScanTool)item).onTeleport((Player)mc.player, mc.player.getMainHandItem())) {
            new ScanToolTeleportMessage().sendToServer();
        }
        mc.getProfiler().pop();
    }

    @SubscribeEvent
    public static void onPreClientTickEvent(@NotNull ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null || mc.level == null) {
            return;
        }
        if (mc.options.keyPickItem.consumeClick()) {
            ItemStack current;
            Item item;
            BlockPos pos;
            BlockPos blockPos = pos = mc.hitResult != null && mc.hitResult.getType() == HitResult.Type.BLOCK ? ((BlockHitResult)mc.hitResult).getBlockPos() : null;
            if (pos != null && mc.level.getBlockState(pos).isAir()) {
                pos = null;
            }
            if ((item = (current = mc.player.getInventory().getSelected()).getItem()) instanceof ISpecialBlockPickItem) {
                ISpecialBlockPickItem clickableItem = (ISpecialBlockPickItem)item;
                boolean ctrlKey = Screen.hasControlDown();
                switch (clickableItem.onBlockPick((Player)mc.player, current, pos, ctrlKey)) {
                    case PASS: {
                        ++mc.options.keyPickItem.clickCount;
                        break;
                    }
                    case FAIL: {
                        break;
                    }
                    default: {
                        new ItemMiddleMouseMessage(pos, ctrlKey).sendToServer();
                        break;
                    }
                }
            } else {
                ++mc.options.keyPickItem.clickCount;
            }
        }
        Iterator<Map.Entry<String, BoxPreviewData>> iterator = RenderingCache.boxRenderingCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BoxPreviewData> entry = iterator.next();
            if (!entry.getValue().isExpired()) continue;
            iterator.remove();
        }
    }

    @SubscribeEvent
    public static void onMouseWheel(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.isCanceled() || mc.player == null || mc.screen != null || mc.level == null) {
            return;
        }
        if (!mc.player.isShiftKeyDown()) {
            return;
        }
        ItemStack current = mc.player.getInventory().getSelected();
        Item item = current.getItem();
        if (item instanceof IScrollableItem) {
            IScrollableItem scrollableItem = (IScrollableItem)item;
            boolean ctrlKey = Screen.hasControlDown();
            switch (scrollableItem.onMouseScroll((Player)mc.player, current, event.getScrollDeltaX(), event.getScrollDeltaY(), ctrlKey)) {
                case PASS: {
                    break;
                }
                case FAIL: {
                    event.setCanceled(true);
                    break;
                }
                default: {
                    event.setCanceled(true);
                    new ItemMiddleMouseMessage(event.getScrollDeltaX(), event.getScrollDeltaY(), ctrlKey).sendToServer();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        WindowExtendedBuildTool.clearStaticData();
    }
}

