/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.api.BlockPosUtil;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.blueprints.v1.DataFixerUtils;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;
import org.apache.logging.log4j.LogManager;

public class UpdateSchematicsCommand
extends AbstractCommand {
    private static final String NAME = "updateschematics";

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)UpdateSchematicsCommand.newLiteral(NAME).executes(s -> UpdateSchematicsCommand.onExecute((CommandContext<CommandSourceStack>)s));
    }

    private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        Path gameFolder = new File(".").toPath().resolve("blueprints").resolve("updater");
        try {
            Files.createDirectories(gameFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (Stream<Path> paths = Files.list(gameFolder.resolve("input"));){
            paths.forEach(element -> UpdateSchematicsCommand.update(element, gameFolder.resolve("input"), gameFolder.resolve("output"), (HolderLookup.Provider)((CommandSourceStack)command.getSource()).registryAccess()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static void update(Path input, Path globalInputFolder, Path globalOutputFolder, HolderLookup.Provider provider) {
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (Stream<Path> paths = Files.list(input);){
                paths.forEach(element -> UpdateSchematicsCommand.update(element, globalInputFolder, globalOutputFolder, provider));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            Path output = globalOutputFolder.resolve(input.toString().replaceAll("\\.nbt", ".blueprint").replace(globalInputFolder.toString(), ""));
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            if (input.toString().endsWith(".blueprint")) {
                CompoundTag bluePrintCompound = BlueprintUtil.writeBlueprintToNBT(UpdateSchematicsCommand.fixBluePrints(input, provider));
                try (BufferedOutputStream outputstream = new BufferedOutputStream(Files.newOutputStream(output, new OpenOption[0]));){
                    NbtIo.writeCompressed((CompoundTag)bluePrintCompound, (OutputStream)outputstream);
                }
                catch (IOException e) {
                    Log.getLogger().warn("Exception while trying to scan.", (Throwable)e);
                }
                return;
            }
            CompoundTag blueprint = NbtIo.readCompressed((InputStream)new ByteArrayInputStream(Files.readAllBytes(input)), (NbtAccounter)NbtAccounter.unlimitedHeap());
            if (blueprint == null || blueprint.isEmpty()) {
                return;
            }
            ListTag blocks = blueprint.getList("blocks", 10);
            ListTag pallete = blueprint.getList("palette", 10);
            CompoundTag bluePrintCompound = new CompoundTag();
            ListTag list = blueprint.getList("size", 3);
            int[] size = new int[]{list.getInt(0), list.getInt(1), list.getInt(2)};
            bluePrintCompound.putShort("size_x", (short)size[0]);
            bluePrintCompound.putShort("size_y", (short)size[1]);
            bluePrintCompound.putShort("size_z", (short)size[2]);
            boolean addStructureVoid = blocks.size() != size[0] * size[1] * size[2];
            short structureVoidID = 0;
            if (addStructureVoid) {
                structureVoidID = (short)pallete.size();
                pallete.add((Object)NbtUtils.writeBlockState((BlockState)Blocks.STRUCTURE_VOID.defaultBlockState()));
            }
            HashSet<String> mods = new HashSet<String>();
            for (int i = 0; i < pallete.size(); ++i) {
                CompoundTag blockState = pallete.getCompound(i);
                String modid = blockState.getString("Name").split(":")[0];
                mods.add(modid);
            }
            ListTag requiredMods = new ListTag();
            for (String str : mods) {
                requiredMods.add((Object)StringTag.valueOf((String)str));
            }
            bluePrintCompound.put("palette", (Tag)pallete);
            bluePrintCompound.put("required_mods", (Tag)requiredMods);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            short[][][] dataArray = new short[size[1]][size[2]][size[0]];
            if (addStructureVoid) {
                for (int i = 0; i < size[1]; ++i) {
                    for (int j = 0; j < size[2]; ++j) {
                        for (int k = 0; k < size[0]; ++k) {
                            dataArray[i][j][k] = structureVoidID;
                        }
                    }
                }
            }
            ListTag tileEntities = new ListTag();
            for (int i = 0; i < blocks.size(); ++i) {
                CompoundTag comp = blocks.getCompound(i);
                UpdateSchematicsCommand.updatePos(pos, comp);
                dataArray[pos.getY()][pos.getZ()][pos.getX()] = (short)comp.getInt("state");
                if (!comp.contains("nbt")) continue;
                CompoundTag te = comp.getCompound("nbt");
                te.putShort("x", (short)pos.getX());
                te.putShort("y", (short)pos.getY());
                te.putShort("z", (short)pos.getZ());
                tileEntities.add((Object)te);
            }
            bluePrintCompound.putIntArray("blocks", UpdateSchematicsCommand.convertBlocksToSaveData(dataArray, (short)size[0], (short)size[1], (short)size[2]));
            bluePrintCompound.put("tile_entities", (Tag)tileEntities);
            bluePrintCompound.put("architects", (Tag)new ListTag());
            bluePrintCompound.put("name", (Tag)StringTag.valueOf((String)input.toString().replaceAll("\\.nbt", "")));
            bluePrintCompound.putInt("version", 1);
            ListTag newEntities = new ListTag();
            if (blueprint.contains("entities")) {
                ListTag entities = blueprint.getList("entities", 10);
                for (int i = 0; i < entities.size(); ++i) {
                    CompoundTag entityData = entities.getCompound(i);
                    CompoundTag entity = entityData.getCompound("nbt");
                    entity.put("Pos", entityData.get("pos"));
                    newEntities.add((Object)entity);
                }
            }
            bluePrintCompound.put("entities", (Tag)newEntities);
            try (BufferedOutputStream outputstream = new BufferedOutputStream(Files.newOutputStream(output, new OpenOption[0]));){
                NbtIo.writeCompressed((CompoundTag)bluePrintCompound, (OutputStream)outputstream);
            }
            catch (IOException e) {
                Log.getLogger().warn("Exception while trying to scan.", (Throwable)e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Blueprint fixBluePrints(Path input, HolderLookup.Provider provider) {
        try {
            CompoundTag compoundNBT = NbtIo.readCompressed((InputStream)new ByteArrayInputStream(Files.readAllBytes(input)), (NbtAccounter)NbtAccounter.unlimitedHeap());
            return UpdateSchematicsCommand.readBlueprintFromNBT(compoundNBT, provider);
        }
        catch (Exception e) {
            Log.getLogger().warn("Could not read file:" + input.toString());
            return null;
        }
    }

    public static Blueprint readBlueprintFromNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        CompoundTag tag = nbtTag;
        byte version = tag.getByte("version");
        if (version == 1) {
            CompoundTag optionalTag;
            short sizeX = tag.getShort("size_x");
            short sizeY = tag.getShort("size_y");
            short sizeZ = tag.getShort("size_z");
            ArrayList<String> requiredMods = new ArrayList<String>();
            ArrayList<String> missingMods = new ArrayList<String>();
            ListTag modsList = (ListTag)tag.get("required_mods");
            int modListSize = modsList.size();
            for (int i = 0; i < modListSize; ++i) {
                requiredMods.add(modsList.get(i).getAsString());
                if (((String)requiredMods.get(i)).equals("minecraft") || ModList.get().getModContainerById((String)requiredMods.get(i)).isPresent()) continue;
                LogManager.getLogger().warn("Found missing mods for Blueprint, some blocks may be missing: " + (String)requiredMods.get(i));
                missingMods.add((String)requiredMods.get(i));
            }
            int oldDataVersion = tag.contains("mcversion") ? tag.getInt("mcversion") : BlueprintUtil.DEFAULT_FIXER_IF_NOT_FOUND;
            ListTag paletteTag = (ListTag)tag.get("palette");
            ArrayList<BlockState> palette = new ArrayList<BlockState>();
            short[][][] blocks = BlueprintUtil.convertSaveDataToBlocks(tag.getIntArray("blocks"), sizeX, sizeY, sizeZ);
            CompoundTag[] tes = BlueprintUtil.fixTileEntities(oldDataVersion, (ListTag)tag.get("tile_entities"));
            ArrayList<CompoundTag> teList = new ArrayList<CompoundTag>();
            UpdateSchematicsCommand.fixPalette(oldDataVersion, palette, teList, paletteTag, blocks, new BlockPos((int)sizeX, (int)sizeY, (int)sizeZ));
            teList.addAll(Arrays.stream(tes).toList());
            CompoundTag[] tileEntities = teList.toArray(new CompoundTag[0]);
            CompoundTag[] entities = BlueprintUtil.fixEntities(oldDataVersion, (ListTag)tag.get("entities"));
            if (oldDataVersion == BlueprintUtil.DEFAULT_FIXER_IF_NOT_FOUND) {
                BlueprintUtil.fixCross1343(palette, blocks, tileEntities, entities);
            }
            Blueprint schem = new Blueprint(sizeX, sizeY, sizeZ, (short)palette.size(), palette, blocks, tileEntities, requiredMods, provider).setMissingMods(missingMods.toArray(new String[0]));
            schem.setEntities(entities);
            if (tag.getAllKeys().contains("name")) {
                schem.setName(tag.getString("name"));
            }
            if (tag.getAllKeys().contains("architects")) {
                ListTag architectsTag = (ListTag)tag.get("architects");
                String[] architects = new String[architectsTag.size()];
                for (int i = 0; i < architectsTag.size(); ++i) {
                    architects[i] = architectsTag.getString(i);
                }
                schem.setArchitects(architects);
            }
            if (tag.getAllKeys().contains("optional_data") && (optionalTag = tag.getCompound("optional_data")).getAllKeys().contains("structurize")) {
                CompoundTag structurizeTag = optionalTag.getCompound("structurize");
                BlockPos offsetPos = BlockPosUtil.readFromNBT(structurizeTag, "primary_offset");
                schem.setCachePrimaryOffset(offsetPos);
            }
            return schem;
        }
        return null;
    }

    public static void fixPalette(int oldDataVersion, List<BlockState> palette, List<CompoundTag> tileEntities, ListTag paletteTag, short[][][] blocks, BlockPos blockPos) {
        short paletteSize = (short)paletteTag.size();
        for (short i = 0; i < paletteSize; i = (short)(i + 1)) {
            CompoundTag nbt = paletteTag.getCompound((int)i);
            try {
                BlockState state;
                CompoundTag fixedNbt = DataFixerUtils.runDataFixer(nbt, References.BLOCK_STATE, oldDataVersion);
                String name = fixedNbt.getString("Name");
                if (!name.startsWith("%s:".formatted("structurize"))) {
                    state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)fixedNbt);
                    palette.add(i, state);
                    continue;
                }
                state = NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)fixedNbt);
                palette.add(i, state);
                continue;
            }
            catch (Exception e) {
                palette.add(i, Blocks.AIR.defaultBlockState());
                Log.getLogger().warn("Blueprint reader: something went wrong loading block at position: " + i, (Throwable)e);
            }
        }
    }

    private static void updatePos(BlockPos.MutableBlockPos pos, CompoundTag comp) {
        ListTag list = comp.getList("pos", 3);
        pos.set(list.getInt(0), list.getInt(1), list.getInt(2));
    }

    private static int[] convertBlocksToSaveData(short[][][] multDimArray, short sizeX, short sizeY, short sizeZ) {
        int currentInt;
        short[] oneDimArray = new short[sizeX * sizeY * sizeZ];
        int j = 0;
        for (short y = 0; y < sizeY; y = (short)(y + 1)) {
            for (short z = 0; z < sizeZ; z = (short)(z + 1)) {
                for (short x = 0; x < sizeX; x = (short)(x + 1)) {
                    oneDimArray[j++] = multDimArray[y][z][x];
                }
            }
        }
        int[] ints = new int[(int)Math.ceil((float)oneDimArray.length / 2.0f)];
        for (int i = 1; i < oneDimArray.length; i += 2) {
            currentInt = oneDimArray[i - 1];
            ints[(int)Math.ceil((double)((double)((float)i / 2.0f))) - 1] = currentInt = currentInt << 16 | oneDimArray[i];
        }
        if (oneDimArray.length % 2 == 1) {
            ints[ints.length - 1] = currentInt = oneDimArray[oneDimArray.length - 1] << 16;
        }
        return ints;
    }
}

