/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui.util;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.api.ItemStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;

public class ItemUtil {
    public static List<ItemStack> getAllItems() {
        return ImmutableList.copyOf((Collection)StreamSupport.stream(Spliterators.spliteratorUnknownSize(BuiltInRegistries.ITEM.iterator(), 16), false).filter(item -> item instanceof AirItem || item instanceof BlockItem || item instanceof BucketItem && ((BucketItem)item).content != Fluids.EMPTY).map(ItemStack::new).collect(Collectors.toList()));
    }

    public static List<ItemStack> getAllItemsInlcudingInventory() {
        HashSet<ItemStorage> items = new HashSet<ItemStorage>();
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof AirItem) && !(item instanceof BlockItem) && (!(item instanceof BucketItem) || ((BucketItem)item).content == Fluids.EMPTY)) continue;
            items.add(new ItemStorage(new ItemStack((ItemLike)item)));
        }
        for (ItemStack stack : Minecraft.getInstance().player.getInventory().items) {
            Item item = stack.getItem();
            if (!(item instanceof AirItem) && !(item instanceof BlockItem) && (!(item instanceof BucketItem) || ((BucketItem)item).content == Fluids.EMPTY)) continue;
            items.add(new ItemStorage(stack.copy()));
        }
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>(items.size());
        for (ItemStorage storage : items) {
            stackList.add(storage.getItemStack());
        }
        return stackList;
    }
}

