/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.util.InputFilters;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowSelectRes
extends AbstractWindowSkeleton {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String INPUT_RESOURCES = "input";
    public static final String RESOURCE_ICON_FROM = "resourceIconFrom";
    public static final String RESOURCE_NAME_FROM = "resourceNameFrom";
    public static final String MIDDLE_LABEL = "to";
    public static final String RESOURCE_ICON_TO = "resourceIconTo";
    public static final String RESOURCE_NAME_TO = "resourceNameTo";
    public static final String COUNT = "count";
    public static final String COUNT_TEXT = "countText";
    public static final String RESOURCE_LIST_VIEW = "pickres";
    public static final String RESOURCE_LIST = "resources";
    public static final String RESOURCE_LIST_SELECT = "select";
    public static final String DESC = "desc";
    public static final String RESOURCE_LIST_RESOURCE_NAME = "resourceName";
    public static final String RESOURCE_LIST_RESOURCE_ICON = "resourceIcon";
    private static final int WHITE = Color.getByName((String)"white", (int)0);
    private final List<ItemStack> allItems;
    private final List<ItemStack> displayedItems = new ArrayList<ItemStack>();
    private final BiConsumer<ItemStack, Integer> resultAction;
    private final boolean secondaryConfirm;
    private Component selectCountText = null;
    private Component desc = Component.empty();
    private String filter = "";
    private int updateResourcesTimer = 0;
    private final ScrollingList resourceList;
    public final BOWindow origin;

    public WindowSelectRes(@Nullable BOWindow origin, Component description, @Nullable ItemStack previousItem, List<ItemStack> allItems, BiConsumer<ItemStack, Integer> resultAction) {
        this(ResourceLocation.fromNamespaceAndPath((String)"structurize", (String)"gui/windowselectres.xml"), origin, description, previousItem, allItems, resultAction, false, null);
    }

    public WindowSelectRes(@Nullable BOWindow origin, Component description, @Nullable ItemStack previousItem, List<ItemStack> allItems, BiConsumer<ItemStack, Integer> resultAction, boolean secondaryConfirm, @Nullable Component selectCountText) {
        this(ResourceLocation.fromNamespaceAndPath((String)"structurize", (String)"gui/windowselectres.xml"), origin, description, previousItem, allItems, resultAction, secondaryConfirm, selectCountText);
    }

    public WindowSelectRes(ResourceLocation xml, @Nullable BOWindow origin, Component description, @Nullable ItemStack previousItem, List<ItemStack> allItems, BiConsumer<ItemStack, Integer> resultAction, boolean secondaryConfirm, @Nullable Component selectCountText) {
        super(xml);
        this.allItems = allItems;
        this.secondaryConfirm = selectCountText != null ? true : secondaryConfirm;
        this.selectCountText = selectCountText;
        this.desc = description;
        this.origin = origin;
        this.resultAction = resultAction;
        Text descText = (Text)this.findPaneOfTypeByID(DESC, Text.class);
        ItemIcon fromStackIcon = (ItemIcon)this.findPaneOfTypeByID(RESOURCE_ICON_FROM, ItemIcon.class);
        Text fromStackDesc = (Text)this.findPaneOfTypeByID(RESOURCE_NAME_FROM, Text.class);
        Text fromToLabel = (Text)this.findPaneOfTypeByID(MIDDLE_LABEL, Text.class);
        ItemIcon toStackIcon = (ItemIcon)this.findPaneOfTypeByID(RESOURCE_ICON_TO, ItemIcon.class);
        Text toStackDesc = (Text)this.findPaneOfTypeByID(RESOURCE_NAME_TO, Text.class);
        TextField countField = (TextField)this.findPaneOfTypeByID(COUNT, TextField.class);
        Text countText = (Text)this.findPaneOfTypeByID(COUNT_TEXT, Text.class);
        ButtonImage buttonSecondaryConfirm = (ButtonImage)this.findPaneOfTypeByID(BUTTON_DONE, ButtonImage.class);
        ButtonImage buttonCancel = (ButtonImage)this.findPaneOfTypeByID(BUTTON_CANCEL, ButtonImage.class);
        View resPicker = (View)this.findPaneOfTypeByID(RESOURCE_LIST_VIEW, View.class);
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID(RESOURCE_LIST, ScrollingList.class);
        TextField selectResFilter = (TextField)this.findPaneOfTypeByID(INPUT_RESOURCES, TextField.class);
        descText.setText(this.desc);
        if (previousItem != null) {
            fromStackIcon.setItem(previousItem);
            fromStackIcon.setVisible(true);
            fromStackDesc.setText(previousItem.getHoverName());
            fromStackDesc.setVisible(true);
            fromToLabel.setVisible(true);
        }
        if (secondaryConfirm) {
            toStackIcon.setItem(Items.AIR.getDefaultInstance());
            toStackIcon.setVisible(true);
            toStackDesc.setText(Items.AIR.getDefaultInstance().getHoverName());
            toStackDesc.setVisible(true);
            buttonSecondaryConfirm.setVisible(true);
        }
        countField.setText("1");
        if (this.selectCountText != null) {
            countField.setVisible(true);
            countField.setFilter(InputFilters.ONLY_POSITIVE_NUMBERS_MAX1k);
            countText.setVisible(true);
            countText.setText(selectCountText);
        }
        resPicker.setVisible(true);
        this.registerButton(buttonSecondaryConfirm.getID(), this::secondaryConfirm);
        this.registerButton(buttonCancel.getID(), this::cancelClicked);
        this.registerButton(RESOURCE_LIST_SELECT, this::selectClicked);
        selectResFilter.setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.updateResourcesTimer = 10;
            }
        });
    }

    public void onOpened() {
        this.updateResources();
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.updateResourcesTimer > 0 && --this.updateResourcesTimer == 0) {
            this.updateResources();
        }
    }

    private void restoreOrigin() {
        this.close();
        if (this.origin != null) {
            this.origin.open();
            this.origin.onOpened();
        }
    }

    protected void secondaryConfirm(Button button) {
        ItemStack to = ((ItemIcon)this.findPaneOfTypeByID(RESOURCE_ICON_TO, ItemIcon.class)).getItem();
        this.onSelectResource(to, this.getCount());
    }

    public void onSelectResource(ItemStack stack, Integer count) {
        this.resultAction.accept(stack, count);
        this.restoreOrigin();
    }

    protected void cancelClicked(Button button) {
        this.restoreOrigin();
    }

    protected void selectClicked(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ItemStack to = this.displayedItems.get(row);
        ((ItemIcon)this.findPaneOfTypeByID(RESOURCE_ICON_TO, ItemIcon.class)).setItem(to);
        ((Text)this.findPaneOfTypeByID(RESOURCE_NAME_TO, Text.class)).setText(to.getHoverName());
        if (!this.secondaryConfirm) {
            this.onSelectResource(to, this.getCount());
        }
    }

    private int getCount() {
        int count = 1;
        if (this.selectCountText != null) {
            try {
                count = Integer.parseInt(((TextField)this.findPaneOfTypeByID(COUNT, TextField.class)).getText());
            }
            catch (NumberFormatException ex) {
                Log.getLogger().warn("Invalid input in Selection BOWindow for Quantity, defaulting to 1!");
            }
        }
        return count;
    }

    private void updateResources() {
        this.displayedItems.clear();
        for (ItemStack stack : this.allItems) {
            if (!this.filter.isEmpty() && !stack.getDescriptionId().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !stack.getHoverName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) continue;
            this.displayedItems.add(stack);
        }
        if (this.filter.isEmpty()) {
            this.displayedItems.sort(Comparator.comparing(s -> this.mc.player.getInventory().contains((ItemStack)s)).reversed().thenComparing(s1 -> ((ItemStack)s1).getHoverName().getString()));
        } else {
            this.displayedItems.sort(Comparator.comparing(s -> this.mc.player.getInventory().contains((ItemStack)s)).reversed().thenComparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)((ItemStack)s1).getHoverName().getString(), (CharSequence)this.filter)));
        }
        this.updateResourceList();
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.displayedItems);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID(WindowSelectRes.RESOURCE_LIST_RESOURCE_NAME, Text.class);
                resourceLabel.setText(resource.getHoverName());
                resourceLabel.setColors(WHITE);
                ((ItemIcon)rowPane.findPaneOfTypeByID(WindowSelectRes.RESOURCE_LIST_RESOURCE_ICON, ItemIcon.class)).setItem(resource);
            }
        });
    }
}

