/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Color;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.CheckBox;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.api.ItemStorage;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.WindowReplaceBlock;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.client.gui.util.InputFilters;
import com.ldtteam.structurize.client.gui.util.ItemPositionsStorage;
import com.ldtteam.structurize.network.messages.FillTopPlaceholderMessage;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.ScanToolData;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowScan
extends AbstractWindowSkeleton {
    private static final String BUILDING_NAME_RESOURCE_SUFFIX = ":gui/windowscantool.xml";
    private static final String CHEST_WARNING = "chestwarning";
    private final Map<ItemStorage, ItemPositionsStorage> allResources = new HashMap<ItemStorage, ItemPositionsStorage>();
    private final Object2IntMap<EntityType<?>> entities = new Object2IntOpenHashMap();
    public static final int WHITE = Color.getByName((String)"white", (int)0);
    private ScanToolData data;
    private String filter = "";
    private final TextField pos1x;
    private final TextField pos1y;
    private final TextField pos1z;
    private final TextField pos2x;
    private final TextField pos2y;
    private final TextField pos2z;
    private final TextField slotId;
    private final ScrollingList resourceList;
    private final ScrollingList entityList;
    private int updateFilterTimer = 0;
    private ArrayList<ItemStorage> visibleResourcesSortedList = new ArrayList();

    public WindowScan(@NotNull ScanToolData data) {
        super("structurize:gui/windowscantool.xml");
        this.data = data;
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::discardClicked);
        this.registerButton("showRes", this::showResClicked);
        this.registerButton("showvisisble", this::updateResources);
        this.registerButton("showhidden", this::updateResources);
        this.registerButton("removeEntity", this::removeEntity);
        this.registerButton("removeBlock", this::removeBlock);
        this.registerButton("replaceBlock", this::replaceBlock);
        this.registerButton("fillplaceholders", this::showFillplaceholderUI);
        this.registerButton("cancelfill", this::cancelFill);
        this.registerButton("fill", this::fillPlaceholders);
        this.registerButton("undoredo", (Button b) -> {
            this.close();
            new WindowUndoRedo().open();
        });
        this.registerButton("removefiltered", this::removeFilteredBlock);
        this.pos1x = (TextField)this.findPaneOfTypeByID("pos1x", TextField.class);
        this.pos1y = (TextField)this.findPaneOfTypeByID("pos1y", TextField.class);
        this.pos1z = (TextField)this.findPaneOfTypeByID("pos1z", TextField.class);
        this.pos2x = (TextField)this.findPaneOfTypeByID("pos2x", TextField.class);
        this.pos2y = (TextField)this.findPaneOfTypeByID("pos2y", TextField.class);
        this.pos2z = (TextField)this.findPaneOfTypeByID("pos2z", TextField.class);
        this.slotId = (TextField)this.findPaneOfTypeByID("slot", TextField.class);
        this.pos1x.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos1y.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos1z.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos2x.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos2y.setFilter(InputFilters.ONLY_NUMBERS);
        this.pos2z.setFilter(InputFilters.ONLY_NUMBERS);
        this.slotId.setFilter(InputFilters.ONLY_NUMBERS);
        this.resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.entityList = (ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class);
    }

    private void showFillplaceholderUI() {
        ((View)this.findPaneOfTypeByID("fillplaceholdersui", View.class)).setVisible(true);
        ((ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class)).setVisible(false);
        ((ButtonImage)this.findPaneOfTypeByID("fillplaceholders", ButtonImage.class)).setVisible(false);
    }

    private void cancelFill() {
        ((View)this.findPaneOfTypeByID("fillplaceholdersui", View.class)).setVisible(false);
        ((ScrollingList)this.findPaneOfTypeByID("entities", ScrollingList.class)).setVisible(true);
        ((ButtonImage)this.findPaneOfTypeByID("fillplaceholders", ButtonImage.class)).setVisible(true);
    }

    private void fillPlaceholders() {
        try {
            double yStretch = Double.parseDouble(((TextField)this.findPaneOfTypeByID("ystretch", TextField.class)).getText());
            double circleRadiusMult = Double.parseDouble(((TextField)this.findPaneOfTypeByID("radius", TextField.class)).getText());
            int heightOffset = Integer.parseInt(((TextField)this.findPaneOfTypeByID("heightoffset", TextField.class)).getText());
            int minDistToBlocks = Integer.parseInt(((TextField)this.findPaneOfTypeByID("blockdist", TextField.class)).getText());
            new FillTopPlaceholderMessage(this.data.currentSlot().box().pos1(), this.data.currentSlot().box().pos2(), yStretch, circleRadiusMult, heightOffset, minDistToBlocks).sendToServer();
        }
        catch (Exception e) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Invalid Number"), false);
        }
        this.close();
    }

    private void showResClicked() {
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).show();
        ((Button)this.findPaneOfTypeByID("showRes", Button.class)).hide();
        ((Button)this.findPaneOfTypeByID("removefiltered", Button.class)).show();
        ((CheckBox)this.findPaneOfTypeByID("showvisisble", CheckBox.class)).show();
        ((CheckBox)this.findPaneOfTypeByID("showvisisble", CheckBox.class)).setChecked(true);
        ((CheckBox)this.findPaneOfTypeByID("showhidden", CheckBox.class)).show();
        ((CheckBox)this.findPaneOfTypeByID("showhidden", CheckBox.class)).setChecked(true);
        this.updateResources();
    }

    private void removeEntity(Button button) {
        int x1 = Integer.parseInt(this.pos1x.getText());
        int y1 = Integer.parseInt(this.pos1y.getText());
        int z1 = Integer.parseInt(this.pos1z.getText());
        int x2 = Integer.parseInt(this.pos2x.getText());
        int y2 = Integer.parseInt(this.pos2y.getText());
        int z2 = Integer.parseInt(this.pos2z.getText());
        int row = this.entityList.getListElementIndexByPane((Pane)button);
        EntityType entity = (EntityType)new ArrayList(this.entities.keySet()).get(row);
        new RemoveEntityMessage(new BlockPos(x1, y1, z1), new BlockPos(x2, y2, z2), EntityType.getKey((EntityType)entity)).sendToServer();
        this.entities.removeInt((Object)entity);
        this.updateEntitylist();
    }

    private void removeBlock(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ItemPositionsStorage toRemove = this.allResources.get(this.visibleResourcesSortedList.get(row));
        new RemoveBlockMessage(toRemove).sendToServer();
        this.removeAllNeededResource(toRemove.itemStorage.getItemStack());
        this.updateResourceList();
    }

    private Set<ItemStorage> getResources() {
        return this.allResources.keySet();
    }

    private void removeFilteredBlock() {
        new RemoveBlockMessage(this.allResources.values().stream().toList()).sendToServer();
        this.allResources.clear();
        this.updateResourceList();
    }

    private void replaceBlock(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        new WindowReplaceBlock(this, this.allResources.get(this.visibleResourcesSortedList.get(row))).open();
    }

    public void onOpened() {
        super.onOpened();
        if (!Minecraft.getInstance().player.isCreative()) {
            this.pos1x.disable();
            this.pos1y.disable();
            this.pos1z.disable();
            this.pos2x.disable();
            this.pos2y.disable();
            this.pos2z.disable();
        }
        this.loadSlot();
        ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).setHandler(input -> {
            this.filter = ((TextField)this.findPaneOfTypeByID("filter", TextField.class)).getText();
            this.updateFilterTimer = 10;
        });
        this.updateFilterTimer = 30;
    }

    public void onClosed() {
        if (RenderingCache.getBoxPreviewData("scan") != null) {
            this.updateBounds();
        }
        super.onClosed();
    }

    public void onUpdate() {
        if (this.updateFilterTimer > 0) {
            --this.updateFilterTimer;
            if (this.updateFilterTimer == 0) {
                this.updateResources();
            }
        }
        super.onUpdate();
    }

    private void discardClicked() {
        RenderingCache.removeBox("scan");
        Iterator<Map.Entry<String, BoxPreviewData>> iterator = RenderingCache.boxRenderingCache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, BoxPreviewData> entry = iterator.next();
            if (!entry.getKey().contains("clickedResource")) continue;
            iterator.remove();
        }
        this.close();
    }

    private void confirmClicked() {
        this.updateBounds();
        new ScanOnServerMessage(this.data.currentSlot(), true).sendToServer();
        RenderingCache.removeBox("scan");
        this.close();
    }

    public boolean onUnhandledKeyTyped(int ch, int key) {
        if (ch >= 48 && ch <= 57) {
            this.updateBounds();
            this.data = this.data.moveTo(ch - 48);
            this.loadSlot();
            this.updateResources();
            return true;
        }
        return super.onUnhandledKeyTyped(ch, key);
    }

    private void loadSlot() {
        BlockEntity tile;
        this.slotId.setText(String.valueOf(this.data.currentSlotId()));
        ScanToolData.Slot slot = this.data.currentSlot();
        this.pos1x.setText(String.valueOf(slot.box().pos1().getX()));
        this.pos1y.setText(String.valueOf(slot.box().pos1().getY()));
        this.pos1z.setText(String.valueOf(slot.box().pos1().getZ()));
        this.pos2x.setText(String.valueOf(slot.box().pos2().getX()));
        this.pos2y.setText(String.valueOf(slot.box().pos2().getY()));
        this.pos2z.setText(String.valueOf(slot.box().pos2().getZ()));
        RenderingCache.queue("scan", slot.box());
        ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText("");
        if (!slot.name().isEmpty()) {
            ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText(slot.name());
        } else if (slot.box().anchor().isPresent() && (tile = Minecraft.getInstance().player.level().getBlockEntity(slot.box().anchor().get())) instanceof IBlueprintDataProviderBE && !((IBlueprintDataProviderBE)tile).getSchematicName().isEmpty()) {
            ((TextField)this.findPaneOfTypeByID("name", TextField.class)).setText(((IBlueprintDataProviderBE)tile).getSchematicName());
        }
    }

    private void updateBounds() {
        BlockPos pos2;
        BlockPos pos1;
        BlockPos def = Minecraft.getInstance().player.blockPosition();
        try {
            int x1 = this.pos1x.getText().isEmpty() ? def.getX() : Integer.parseInt(this.pos1x.getText());
            int y1 = this.pos1y.getText().isEmpty() ? def.getY() : Integer.parseInt(this.pos1y.getText());
            int z1 = this.pos1z.getText().isEmpty() ? def.getZ() : Integer.parseInt(this.pos1z.getText());
            pos1 = new BlockPos(x1, y1, z1);
            int x2 = this.pos2x.getText().isEmpty() ? def.getX() : Integer.parseInt(this.pos2x.getText());
            int y2 = this.pos2y.getText().isEmpty() ? def.getY() : Integer.parseInt(this.pos2y.getText());
            int z2 = this.pos2z.getText().isEmpty() ? def.getZ() : Integer.parseInt(this.pos2z.getText());
            pos2 = new BlockPos(x2, y2, z2);
        }
        catch (NumberFormatException e) {
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Invalid Number"), false);
            return;
        }
        String name = ((TextField)this.findPaneOfTypeByID("name", TextField.class)).getText();
        this.data = this.data.withCurrentSlot(new ScanToolData.Slot(name, this.data.currentSlot().box().withCorners(pos1, pos2)));
        RenderingCache.queue("scan", this.data.currentSlot().box());
        new UpdateScanToolMessage(this.data).sendToServer();
    }

    private void updateResources() {
        this.updateFilterTimer = 0;
        this.updateBounds();
        ClientLevel world = Minecraft.getInstance().level;
        this.allResources.clear();
        this.entities.clear();
        if (this.findPaneByID("showRes").isVisible()) {
            return;
        }
        BoxPreviewData box = this.data.currentSlot().box();
        List list = world.getEntitiesOfClass(Entity.class, AABB.encapsulatingFullBlocks((BlockPos)box.pos1(), (BlockPos)box.pos2()));
        for (Entity entity : list) {
            if (this.entities.containsKey((Object)entity.getName().getString()) || !entity.getType().canSerialize() && !entity.getType().equals(EntityType.LEASH_KNOT) || !this.filter.isEmpty() && !entity.getName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) && !entity.toString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) continue;
            this.entities.mergeInt((Object)entity.getType(), 1, Integer::sum);
        }
        BlockPos.MutableBlockPos here = new BlockPos.MutableBlockPos();
        int minX = Math.min(box.pos1().getX(), box.pos2().getX());
        int minY = Math.min(box.pos1().getY(), box.pos2().getY());
        int minZ = Math.min(box.pos1().getZ(), box.pos2().getZ());
        int maxX = Math.max(box.pos1().getX(), box.pos2().getX());
        int maxY = Math.max(box.pos1().getY(), box.pos2().getY());
        int maxZ = Math.max(box.pos1().getZ(), box.pos2().getZ());
        BoundingBox boundingBox = BoundingBox.fromCorners((Vec3i)box.pos1(), (Vec3i)box.pos2());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    Block block;
                    here.set(x, y, z);
                    BlockState blockState = world.getBlockState((BlockPos)here);
                    BlockEntity tileEntity = world.getBlockEntity((BlockPos)here);
                    boolean visible = false;
                    for (Direction dir : Direction.values()) {
                        BlockPos offsetPos = here.relative(dir);
                        if (boundingBox.isInside((Vec3i)offsetPos) && (!world.getBlockState(offsetPos).canOcclude() || world.getBlockState(offsetPos).getShape((BlockGetter)world, offsetPos) == Shapes.block())) continue;
                        visible = true;
                        break;
                    }
                    if ((block = blockState.getBlock()) == Blocks.AIR || block == Blocks.VOID_AIR || block == Blocks.CAVE_AIR) {
                        this.addNeededResource(new ItemStack((ItemLike)Blocks.AIR, 1), visible, (BlockPos)here);
                        continue;
                    }
                    IPlacementHandler handler = PlacementHandlers.getHandler((Level)world, BlockPos.ZERO, blockState);
                    List<ItemStack> itemList = handler.getRequiredItems((Level)world, (BlockPos)here, blockState, tileEntity == null ? null : tileEntity.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess()), true);
                    for (ItemStack stack : itemList) {
                        this.addNeededResource(stack, visible, (BlockPos)here);
                    }
                }
            }
        }
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
        this.updateResourceList();
        this.updateEntitylist();
    }

    public void addNeededResource(@Nullable ItemStack res, boolean visible, BlockPos pos) {
        if (res == null) {
            return;
        }
        CheckBox visibleCheckBox = (CheckBox)this.findPaneOfTypeByID("showvisisble", CheckBox.class);
        CheckBox hiddenCheckBox = (CheckBox)this.findPaneOfTypeByID("showhidden", CheckBox.class);
        if (visible && !visibleCheckBox.isChecked()) {
            return;
        }
        if (!visible && !hiddenCheckBox.isChecked()) {
            return;
        }
        if (this.filter.isEmpty() || res.getDescriptionId().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || res.getHoverName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US))) {
            ItemStorage stackToStore = new ItemStorage(res, 1, true, false);
            ItemPositionsStorage existing = this.allResources.computeIfAbsent(stackToStore, ItemPositionsStorage::new);
            existing.addItemAndPos(stackToStore, pos.immutable());
        }
    }

    public void removeAllNeededResource(ItemStack res) {
        ItemStorage storage = new ItemStorage(res, 1, true, false);
        this.allResources.remove(storage);
    }

    public void updateEntitylist() {
        this.entityList.enable();
        this.entityList.show();
        final ArrayList tempEntities = new ArrayList(this.entities.keySet());
        this.entityList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempEntities.size();
            }

            public void updateElement(int index, Pane rowPane) {
                EntityType entity = (EntityType)tempEntities.get(index);
                ItemStack entityIcon = entity.create((Level)Minecraft.getInstance().level).getPickResult();
                if (entity == EntityType.GLOW_ITEM_FRAME) {
                    entityIcon = new ItemStack((ItemLike)Items.GLOW_ITEM_FRAME);
                } else if (entity == EntityType.ITEM_FRAME) {
                    entityIcon = new ItemStack((ItemLike)Items.ITEM_FRAME);
                } else if (entity == EntityType.MINECART) {
                    entityIcon = new ItemStack((ItemLike)Items.MINECART);
                }
                ((Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class)).setText(Component.literal((String)Integer.toString(WindowScan.this.entities.getInt((Object)entity))));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(entityIcon);
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(entity.getDescription());
                if (!Minecraft.getInstance().player.isCreative()) {
                    ((Button)rowPane.findPaneOfTypeByID("removeEntity", Button.class)).hide();
                }
            }
        });
    }

    public void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        ((Text)this.window.findPaneOfTypeByID(CHEST_WARNING, Text.class)).show();
        this.visibleResourcesSortedList = new ArrayList<ItemStorage>(this.getResources());
        this.visibleResourcesSortedList.sort(Comparator.comparing(s1 -> s1.getItemStack().getHoverName().getString()));
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowScan.this.visibleResourcesSortedList.size();
            }

            public void updateElement(int index, Pane rowPane) {
                ItemStorage resource = WindowScan.this.visibleResourcesSortedList.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                Text quantityLabel = (Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class);
                resourceLabel.setText(resource.getItemStack().getHoverName());
                quantityLabel.setText(Component.literal((String)Integer.toString(resource.getAmount())));
                resourceLabel.setColors(WHITE);
                quantityLabel.setColors(WHITE);
                ItemStack copy = resource.getItemStack().copy();
                copy.setCount(1);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(copy);
                if (!Minecraft.getInstance().player.isCreative()) {
                    ((Button)rowPane.findPaneOfTypeByID("removeBlock", Button.class)).hide();
                    ((Button)rowPane.findPaneOfTypeByID("replaceBlock", Button.class)).hide();
                }
                ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>(((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).getModifiedItemStackTooltip());
                tooltip.add(Component.translatable((String)"com.ldtteam.structurize.gui.scantool.item.tooltipclick"));
                new AbstractTextBuilder.AutomaticTooltipBuilder().hoverPane(rowPane.findPaneOfTypeByID("showBlock", Button.class)).build().setTextOld(tooltip);
                ((Button)rowPane.findPaneOfTypeByID("showBlock", Button.class)).setHandler(b -> this.doHighLightBlocks(b, resource));
            }

            private void doHighLightBlocks(Button button, ItemStorage block) {
                ItemPositionsStorage itemPositionsStorage = WindowScan.this.allResources.get(block);
                for (BlockPos position : itemPositionsStorage.positions) {
                    BoxPreviewData previewData = new BoxPreviewData(position, position, Optional.empty());
                    previewData.setExpireTime(30);
                    RenderingCache.queue("clickedResource" + position.toShortString(), previewData);
                }
                WindowScan.this.window.close();
            }
        });
    }
}

