/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.blockentities.BlockEntityTagSubstitution;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtils;
import com.ldtteam.structurize.client.ChunkOffsetBufferBuilderWrapper;
import com.ldtteam.structurize.client.fakelevel.BlueprintBlockAccess;
import com.ldtteam.structurize.component.CapturedBlock;
import com.ldtteam.structurize.config.ClientConfiguration;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import com.ldtteam.structurize.tag.ModTags;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.BlueprintMissHitResult;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL20C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintRenderer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlueprintRenderer.class);
    private static final RenderBuffers renderBuffers = new RenderBuffers(0);
    private static boolean hasWarnedExceptions = false;
    private final BlueprintBlockAccess blockAccess;
    List<Entity> entities = List.of();
    private List<BlockEntity> tileEntities;
    private Map<RenderType, VertexBuffer> vertexBuffers;
    private long lastGameTime;
    private boolean bypassMainFrustum = false;
    private Set<Object> crashingObjects = Collections.newSetFromMap(new IdentityHashMap());

    public static BlueprintRenderer buildRendererForBlueprint(Blueprint blueprint) {
        BlueprintBlockAccess blockAccess = new BlueprintBlockAccess(blueprint);
        return new BlueprintRenderer(blockAccess);
    }

    private BlueprintRenderer(BlueprintBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
    }

    public void updateBlueprint(BlueprintPreviewData previewData) {
        if (this.blockAccess.getLevelSource() != previewData.getBlueprint() && ((Blueprint)this.blockAccess.getLevelSource()).hashCode() == previewData.getBlueprint().hashCode()) {
            this.blockAccess.setLevelSource(previewData.getBlueprint());
        }
    }

    private void init(BlueprintPreviewData previewData, Map<Object, Exception> suppressedExceptions) {
        Blueprint blueprint = previewData.getBlueprint();
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        RandomSource random = RandomSource.create();
        HashMap<BlockPos, ModelData> teModelData = new HashMap<BlockPos, ModelData>();
        Map<BlockPos, BlockEntity> tileEntitiesMap = BlueprintUtils.instantiateTileEntities(blueprint, (Level)this.blockAccess, teModelData);
        this.entities = BlueprintUtils.instantiateEntities(blueprint, (Level)this.blockAccess);
        this.blockAccess.setBlockEntities(tileEntitiesMap);
        this.blockAccess.setEntities(this.entities);
        this.blockAccess.setSolidSubstitutionOverride(previewData.getSolidSubstitutionOverride());
        this.blockAccess.setRenderBlocksNiceOverride(previewData.getRenderBlocksNice());
        PoseStack matrixStack = new PoseStack();
        matrixStack.translate(0.001, 0.001, 0.001);
        ChunkOffsetBufferBuilderWrapper fluidBufferWrapper = new ChunkOffsetBufferBuilderWrapper();
        Reference2ObjectArrayMap chunkBuffers = new Reference2ObjectArrayMap(RenderType.chunkBufferLayers().size());
        RenderType.chunkBufferLayers().forEach(arg_0 -> BlueprintRenderer.lambda$init$0((Map)chunkBuffers, arg_0));
        for (BlockInfo blockInfo : blueprint.getBlockInfoAsList()) {
            BlockPos blockPos = blockInfo.getPos();
            BlockState state = blockInfo.getState();
            if (previewData.getRenderBlocksNice() && state.getBlock() == ModBlocks.blockTagSubstitution.get()) {
                BlockEntity blockEntity = tileEntitiesMap.remove(blockPos);
                if (blockEntity instanceof BlockEntityTagSubstitution) {
                    BlockEntityTagSubstitution tagTE = (BlockEntityTagSubstitution)blockEntity;
                    CapturedBlock replacement = tagTE.getReplacement();
                    state = replacement.blockState();
                    replacement.serializedBE().map(tag -> BlockEntity.loadStatic((BlockPos)blockPos, (BlockState)replacement.blockState(), (CompoundTag)tag, (HolderLookup.Provider)blueprint.getRegistryAccess())).ifPresent(newBe -> {
                        newBe.setLevel((Level)this.blockAccess);
                        teModelData.put(blockPos, newBe.getModelData());
                        tileEntitiesMap.put(blockPos, (BlockEntity)newBe);
                    });
                } else {
                    state = Blocks.AIR.defaultBlockState();
                }
            } else {
                state = this.blockAccess.prepareBlockStateForRendering(state, blockPos);
            }
            FluidState fluidState = state.getFluidState();
            try {
                if (!fluidState.isEmpty()) {
                    RenderType renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState);
                    int chunkOffsetX = blockPos.getX() - (blockPos.getX() & 0xF);
                    int chunkOffsetY = blockPos.getY() - (blockPos.getY() & 0xF);
                    int chunkOffsetZ = blockPos.getZ() - (blockPos.getZ() & 0xF);
                    fluidBufferWrapper.setOffset((BufferBuilder)chunkBuffers.get(renderType), chunkOffsetX, chunkOffsetY, chunkOffsetZ);
                    blockRenderer.renderLiquid(blockPos, (BlockAndTintGetter)this.blockAccess, (VertexConsumer)fluidBufferWrapper, state, fluidState);
                }
                if (state.getRenderShape() == RenderShape.INVISIBLE) continue;
                BakedModel blockModel = blockRenderer.getBlockModel(state);
                ModelData modelData = blockModel.getModelData((BlockAndTintGetter)this.blockAccess, blockPos, state, teModelData.getOrDefault(blockPos, ModelData.EMPTY));
                matrixStack.pushPose();
                matrixStack.translate((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
                for (RenderType renderType : blockModel.getRenderTypes(state, random, modelData)) {
                    BufferBuilder buffer2 = (BufferBuilder)chunkBuffers.get(renderType);
                    blockRenderer.renderBatched(state, blockPos, (BlockAndTintGetter)this.blockAccess, matrixStack, (VertexConsumer)buffer2, true, random, modelData, renderType);
                    renderType.clearRenderState();
                }
                matrixStack.popPose();
            }
            catch (ReportedException e) {
                suppressedExceptions.put(blockInfo, (Exception)((Object)e));
            }
        }
        this.blockAccess.setSolidSubstitutionOverride(null);
        this.blockAccess.setRenderBlocksNiceOverride((Boolean)((ClientConfiguration)Structurize.getConfig().getClient()).renderPlaceholdersNice.get());
        this.clearVertexBuffers();
        this.vertexBuffers = new Reference2ObjectArrayMap(RenderType.chunkBufferLayers().size());
        chunkBuffers.forEach((type, buffer) -> {
            MeshData meshData = buffer.build();
            if (meshData != null) {
                VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
                vertexBuffer.bind();
                vertexBuffer.upload(meshData);
                this.vertexBuffers.put((RenderType)type, vertexBuffer);
            }
        });
        VertexBuffer.unbind();
        this.tileEntities = new ArrayList<BlockEntity>(tileEntitiesMap.values());
    }

    public void draw(BlueprintPreviewData previewData, BlockPos pos, RenderLevelStageEvent ctx) {
        if (this.crashingObjects == null) {
            return;
        }
        try {
            Map<Object, Exception> suppressedExceptions = this.drawUnsafe(previewData, pos, ctx);
            if (!suppressedExceptions.isEmpty()) {
                if (!hasWarnedExceptions) {
                    hasWarnedExceptions = true;
                    Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"structurize.preview_renderer.exception"));
                }
                boolean crashReported = false;
                boolean isEmpty = true;
                for (Map.Entry<Object, Exception> e : suppressedExceptions.entrySet()) {
                    if (!this.crashingObjects.add(e.getKey())) continue;
                    isEmpty = false;
                    Exception exception = e.getValue();
                    if (exception instanceof ReportedException) {
                        ReportedException reportedException = (ReportedException)((Object)exception);
                        BlueprintRenderer.printCrashReport(reportedException.getReport(), previewData);
                        crashReported = true;
                        continue;
                    }
                    LOGGER.error("", (Throwable)e.getValue());
                }
                if (!crashReported && !isEmpty) {
                    BlueprintRenderer.printCrashReport(CrashReport.forThrowable((Throwable)new Exception(), (String)"Small exception, rendering partially"), previewData);
                }
            }
        }
        catch (Exception e) {
            BlueprintRenderer.printCrashReport(CrashReport.forThrowable((Throwable)e, (String)"Fatal exception, cannot render"), previewData);
            this.crashingObjects = null;
            Minecraft.getInstance().player.sendSystemMessage((Component)Component.translatable((String)"structurize.preview_renderer.cannot_render", (Object[])new Object[]{previewData.getBlueprint().getName()}));
        }
    }

    private static void printCrashReport(CrashReport report, BlueprintPreviewData previewData) {
        previewData.getBlueprint().describeSelfInCrashReport(report.addCategory("Blueprint"));
        LOGGER.error(report.getFriendlyReport(new ReportType("Problem during blueprint rendering", ReportType.TEST.nuggets())));
    }

    public Map<Object, Exception> drawUnsafe(BlueprintPreviewData previewData, BlockPos pos, RenderLevelStageEvent ctx) {
        LocalPlayer entity;
        BlockPos anchorPos = pos.subtract((Vec3i)previewData.getBlueprint().getPrimaryBlockOffset());
        if (!ctx.getFrustum().isVisible(previewData.getBlueprint().getAABB().move(anchorPos)) && !this.bypassMainFrustum) {
            return Map.of();
        }
        IdentityHashMap<Object, Exception> suppressedExceptions = new IdentityHashMap<Object, Exception>();
        Minecraft mc = Minecraft.getInstance();
        long gameTime = mc.level.getGameTime();
        PoseStack matrixStack = ctx.getPoseStack();
        DeltaTracker deltaTracker = ctx.getPartialTick();
        ProfilerFiller profiler = mc.getProfiler();
        Matrix4f mvMatrix = ctx.getModelViewMatrix();
        Matrix4f pMatrix = ctx.getProjectionMatrix();
        profiler.push("struct_render_init");
        this.updateBlueprint(previewData);
        this.blockAccess.setWorldPos(anchorPos);
        if (this.vertexBuffers == null) {
            this.init(previewData, suppressedExceptions);
        }
        profiler.popPush("struct_render_prepare");
        Vec3 viewPosition = ctx.getCamera().getPosition();
        Vec3 realRenderRootVecd = Vec3.atLowerCornerOf((Vec3i)anchorPos).subtract(viewPosition);
        Vector3f realRenderRootVecf = realRenderRootVecd.toVector3f();
        Object object = entity = mc.getCameraEntity() == null ? mc.player : mc.getCameraEntity();
        float partialTicks = mc.level.tickRateManager().isEntityFrozen((Entity)entity) ? 1.0f : deltaTracker.getGameTimeDeltaPartialTick(!mc.level.tickRateManager().isFrozen());
        Level dispLevel = mc.getBlockEntityRenderDispatcher().level;
        Camera dispCamera = mc.getBlockEntityRenderDispatcher().camera;
        HitResult beHitResult = mc.getBlockEntityRenderDispatcher().cameraHitResult;
        Entity ePickEntity = mc.getEntityRenderDispatcher().crosshairPickEntity;
        Camera ourCamera = new Camera();
        ourCamera.setup((BlockGetter)this.blockAccess, dispCamera.getEntity(), !mc.options.getCameraType().isFirstPerson(), mc.options.getCameraType().isMirrored(), partialTicks);
        ourCamera.setPosition(viewPosition.subtract((double)anchorPos.getX(), (double)anchorPos.getY(), (double)anchorPos.getZ()));
        mc.getBlockEntityRenderDispatcher().prepare((Level)this.blockAccess, ourCamera, (HitResult)BlueprintMissHitResult.MISS);
        mc.getEntityRenderDispatcher().prepare((Level)this.blockAccess, ourCamera, mc.crosshairPickEntity);
        Frustum blueprintLocalFrustum = new Frustum(ctx.getFrustum());
        blueprintLocalFrustum.prepare(ourCamera.getPosition().x(), ourCamera.getPosition().y(), ourCamera.getPosition().z());
        this.bypassMainFrustum = false;
        if (mc.level.effects().constantAmbientLight()) {
            Lighting.setupNetherLevel();
        } else {
            Lighting.setupLevel();
        }
        if (ctx.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            FogRenderer.setupFog((Camera)ctx.getCamera(), (FogRenderer.FogMode)FogRenderer.FogMode.FOG_TERRAIN, (float)Math.max(mc.gameRenderer.getRenderDistance(), 32.0f), (mc.level.effects().isFoggyAt(Mth.floor((double)viewPosition.x()), Mth.floor((double)viewPosition.y())) || mc.gui.getBossOverlay().shouldCreateWorldFog() ? 1 : 0) != 0, (float)partialTicks);
        }
        profiler.popPush("struct_render_blocks");
        this.renderBlockLayer(RenderType.solid(), mvMatrix, pMatrix, realRenderRootVecf, previewData, mc);
        mc.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).setBlurMipmap(false, (Integer)mc.options.mipmapLevels().get() > 0);
        this.renderBlockLayer(RenderType.cutoutMipped(), mvMatrix, pMatrix, realRenderRootVecf, previewData, mc);
        mc.getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).restoreLastBlurMipmap();
        this.renderBlockLayer(RenderType.cutout(), mvMatrix, pMatrix, realRenderRootVecf, previewData, mc);
        profiler.popPush("struct_render_entities");
        MultiBufferSource.BufferSource renderBufferSource = renderBuffers.bufferSource();
        matrixStack.pushPose();
        matrixStack.translate(realRenderRootVecd.x(), realRenderRootVecd.y(), realRenderRootVecd.z());
        for (Entity entity2 : this.entities) {
            if (!mc.getEntityRenderDispatcher().shouldRender(entity2, blueprintLocalFrustum, ourCamera.getPosition().x(), ourCamera.getPosition().y(), ourCamera.getPosition().z())) continue;
            if (gameTime != this.lastGameTime && entity2.getType().is(ModTags.PREVIEW_TICKING_ENTITIES)) {
                try {
                    entity2.tick();
                }
                catch (Exception e) {
                    suppressedExceptions.put(entity2, e);
                }
            }
            this.bypassMainFrustum |= entity2.noCulling;
            try {
                mc.getEntityRenderDispatcher().render(entity2, entity2.getX(), entity2.getY(), entity2.getZ(), entity2.getYRot(), partialTicks, matrixStack, (MultiBufferSource)renderBufferSource, mc.getEntityRenderDispatcher().getPackedLightCoords(entity2, partialTicks));
            }
            catch (ClassCastException e) {
                suppressedExceptions.put(entity2, e);
            }
        }
        matrixStack.popPose();
        profiler.popPush("struct_render_entities_finish");
        renderBufferSource.endLastBatch();
        renderBufferSource.endBatch(RenderType.entitySolid((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        renderBufferSource.endBatch(RenderType.entityCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        renderBufferSource.endBatch(RenderType.entityCutoutNoCull((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        renderBufferSource.endBatch(RenderType.entitySmoothCutout((ResourceLocation)InventoryMenu.BLOCK_ATLAS));
        profiler.popPush("struct_render_blockentities");
        for (BlockEntity tileEntity : this.tileEntities) {
            BlockEntityRenderer renderer = mc.getBlockEntityRenderDispatcher().getRenderer(tileEntity);
            if (renderer == null || !renderer.shouldRender(tileEntity, ourCamera.getPosition())) continue;
            BlockPos tePos = tileEntity.getBlockPos();
            Vec3 realRenderTePos = realRenderRootVecd.add((double)tePos.getX(), (double)tePos.getY(), (double)tePos.getZ());
            if (gameTime != this.lastGameTime) {
                if (tileEntity instanceof SpawnerBlockEntity) {
                    SpawnerBlockEntity spawner = (SpawnerBlockEntity)tileEntity;
                    SpawnerBlockEntity.clientTick((Level)mc.level, (BlockPos)anchorPos.offset((Vec3i)tePos), (BlockState)this.blockAccess.getBlockState(tePos), (SpawnerBlockEntity)spawner);
                } else if (tileEntity instanceof EnchantingTableBlockEntity) {
                    EnchantingTableBlockEntity enchTable = (EnchantingTableBlockEntity)tileEntity;
                    EnchantingTableBlockEntity.bookAnimationTick((Level)mc.level, (BlockPos)anchorPos.offset((Vec3i)tePos), (BlockState)this.blockAccess.getBlockState(tePos), (EnchantingTableBlockEntity)enchTable);
                } else if (tileEntity instanceof CampfireBlockEntity) {
                    CampfireBlockEntity campfire = (CampfireBlockEntity)tileEntity;
                    bs = this.blockAccess.getBlockState(tePos);
                    if (bs.getBlock() instanceof CampfireBlock && ((Boolean)bs.getValue((Property)CampfireBlock.LIT)).booleanValue()) {
                        CampfireBlockEntity.particleTick((Level)mc.level, (BlockPos)anchorPos.offset((Vec3i)tePos), (BlockState)bs, (CampfireBlockEntity)campfire);
                    }
                } else if (tileEntity instanceof SkullBlockEntity) {
                    SkullBlockEntity skull = (SkullBlockEntity)tileEntity;
                    bs = this.blockAccess.getBlockState(tePos);
                    if (bs.getBlock() instanceof SkullBlock && (bs.is(Blocks.DRAGON_HEAD) || bs.is(Blocks.DRAGON_WALL_HEAD) || bs.is(Blocks.PIGLIN_HEAD) || bs.is(Blocks.PIGLIN_WALL_HEAD))) {
                        SkullBlockEntity.animation((Level)this.blockAccess, (BlockPos)tePos, (BlockState)bs, (SkullBlockEntity)skull);
                    }
                } else if (tileEntity instanceof BeaconBlockEntity) {
                    BeaconBlockEntity beacon = (BeaconBlockEntity)tileEntity;
                    BeaconBlockEntity.tick((Level)this.blockAccess, (BlockPos)tePos, (BlockState)this.blockAccess.getBlockState(tePos), (BeaconBlockEntity)beacon);
                } else if (tileEntity instanceof VaultBlockEntity) {
                    VaultBlockEntity vault = (VaultBlockEntity)tileEntity;
                    VaultBlockEntity.Client.tick((Level)mc.level, (BlockPos)anchorPos.offset((Vec3i)tePos), (BlockState)this.blockAccess.getBlockState(tePos), (VaultClientData)vault.getClientData(), (VaultSharedData)vault.getSharedData());
                } else if (tileEntity instanceof TrialSpawnerBlockEntity) {
                    TrialSpawnerBlockEntity trialSpawner = (TrialSpawnerBlockEntity)tileEntity;
                    trialSpawner.getTrialSpawner().tickClient((Level)mc.level, anchorPos.offset((Vec3i)tePos), this.blockAccess.getBlockState(tePos).getOptionalValue((Property)TrialSpawnerBlock.OMINOUS).orElse(false).booleanValue());
                }
            }
            this.bypassMainFrustum |= renderer.shouldRenderOffScreen(tileEntity);
            if (!blueprintLocalFrustum.isVisible(renderer.getRenderBoundingBox(tileEntity)) && !renderer.shouldRenderOffScreen(tileEntity)) continue;
            matrixStack.pushPose();
            matrixStack.translate(realRenderTePos.x, realRenderTePos.y, realRenderTePos.z);
            mc.getBlockEntityRenderDispatcher().render(tileEntity, partialTicks, matrixStack, (MultiBufferSource)renderBufferSource);
            matrixStack.popPose();
        }
        profiler.popPush("struct_render_blockentities_finish");
        renderBufferSource.endBatch(RenderType.solid());
        renderBufferSource.endBatch(RenderType.endPortal());
        renderBufferSource.endBatch(RenderType.endGateway());
        renderBufferSource.endBatch(Sheets.solidBlockSheet());
        renderBufferSource.endBatch(Sheets.cutoutBlockSheet());
        renderBufferSource.endBatch(Sheets.bedSheet());
        renderBufferSource.endBatch(Sheets.shulkerBoxSheet());
        renderBufferSource.endBatch(Sheets.signSheet());
        renderBufferSource.endBatch(Sheets.hangingSignSheet());
        renderBufferSource.endBatch(Sheets.chestSheet());
        renderBuffers.outlineBufferSource().endOutlineBatch();
        renderBufferSource.endLastBatch();
        renderBufferSource.endBatch(Sheets.translucentCullBlockSheet());
        renderBufferSource.endBatch(Sheets.bannerSheet());
        renderBufferSource.endBatch(Sheets.shieldSheet());
        renderBufferSource.endBatch(RenderType.armorEntityGlint());
        renderBufferSource.endBatch(RenderType.glint());
        renderBufferSource.endBatch(RenderType.glintTranslucent());
        renderBufferSource.endBatch(RenderType.entityGlint());
        renderBufferSource.endBatch(RenderType.entityGlintDirect());
        renderBufferSource.endBatch(RenderType.waterMask());
        renderBuffers.crumblingBufferSource().endBatch();
        profiler.popPush("struct_render_blocks2");
        this.renderBlockLayer(RenderType.translucent(), mvMatrix, pMatrix, realRenderRootVecf, previewData, mc);
        renderBufferSource.endBatch(RenderType.lines());
        renderBufferSource.endBatch();
        this.renderBlockLayer(RenderType.tripwire(), mvMatrix, pMatrix, realRenderRootVecf, previewData, mc);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupLevel();
        if (ctx.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            FogRenderer.setupNoFog();
        }
        mc.getBlockEntityRenderDispatcher().prepare(dispLevel, dispCamera, beHitResult);
        mc.getEntityRenderDispatcher().prepare(dispLevel, dispCamera, ePickEntity);
        this.lastGameTime = gameTime;
        profiler.pop();
        return suppressedExceptions;
    }

    private void clearVertexBuffers() {
        if (this.vertexBuffers != null) {
            this.vertexBuffers.values().forEach(VertexBuffer::close);
            this.vertexBuffers = null;
        }
    }

    @Override
    public void close() {
        this.clearVertexBuffers();
    }

    private void renderBlockLayer(RenderType layerRenderType, Matrix4f mvMatrix, Matrix4f pMatrix, Vector3f realRenderRootPos, BlueprintPreviewData previewData, Minecraft mc) {
        VertexBuffer vertexBuffer = this.vertexBuffers.get(layerRenderType);
        if (vertexBuffer == null) {
            return;
        }
        layerRenderType.setupRenderState();
        ShaderInstance shaderinstance = RenderSystem.getShader();
        shaderinstance.setDefaultUniforms(VertexFormat.Mode.QUADS, mvMatrix, pMatrix, mc.getWindow());
        shaderinstance.apply();
        Uniform uniform = shaderinstance.CHUNK_OFFSET;
        if (uniform != null) {
            uniform.set(realRenderRootPos);
            uniform.upload();
        }
        TransparencyHack.apply(previewData.getOverridePreviewTransparency());
        vertexBuffer.bind();
        vertexBuffer.draw();
        TransparencyHack.reset();
        if (uniform != null) {
            uniform.set(0.0f, 0.0f, 0.0f);
        }
        shaderinstance.clear();
        VertexBuffer.unbind();
        layerRenderType.clearRenderState();
    }

    private static /* synthetic */ void lambda$init$0(Map chunkBuffers, RenderType type) {
        chunkBuffers.put(type, new BufferBuilder(renderBuffers.fixedBufferPack().buffer(type), type.mode(), type.format()));
    }

    public static class TransparencyHack {
        public static final float THRESHOLD = 0.99f;
        protected static boolean applied = false;

        public static void apply(float overrideValue) {
            if (applied || GlStateManager.BLEND.mode.enabled) {
                return;
            }
            float alpha = ((Double)((ClientConfiguration)Structurize.getConfig().getClient()).rendererTransparency.get()).floatValue();
            if (overrideValue != -1.0f) {
                alpha = Mth.clamp((float)overrideValue, (float)0.0f, (float)1.0f);
            }
            if (alpha < 0.0f || alpha > 0.99f) {
                return;
            }
            applied = true;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.CONSTANT_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_CONSTANT_ALPHA);
            GL20C.glBlendColor((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
        }

        public static void reset() {
            if (!applied) {
                return;
            }
            applied = false;
            RenderSystem.disableBlend();
        }
    }
}

