/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api;

import com.ldtteam.structurize.api.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockPosUtil {
    private BlockPosUtil() {
    }

    public static String format(BlockPos pos) {
        return String.format("%d %d %d", pos.getX(), pos.getY(), pos.getZ());
    }

    public static void writeToNBT(CompoundTag compound, String name, BlockPos pos) {
        CompoundTag coordsCompound = new CompoundTag();
        coordsCompound.putInt("x", pos.getX());
        coordsCompound.putInt("y", pos.getY());
        coordsCompound.putInt("z", pos.getZ());
        compound.put(name, (Tag)coordsCompound);
    }

    public static BlockPos readFromNBT(CompoundTag compound, String name) {
        CompoundTag coordsCompound = compound.getCompound(name);
        int x = coordsCompound.getInt("x");
        int y = coordsCompound.getInt("y");
        int z = coordsCompound.getInt("z");
        return new BlockPos(x, y, z);
    }

    public static void writeToNBTTagList(ListTag tagList, BlockPos pos) {
        CompoundTag coordsCompound = new CompoundTag();
        coordsCompound.putInt("x", pos.getX());
        coordsCompound.putInt("y", pos.getY());
        coordsCompound.putInt("z", pos.getZ());
        tagList.add((Object)coordsCompound);
    }

    public static long getDistanceSquared(BlockPos block1, BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.getX() - (long)block2.getX();
        long result = xDiff * xDiff + (yDiff = (long)block1.getY() - (long)block2.getY()) * yDiff + (zDiff = (long)block1.getZ() - (long)block2.getZ()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    public static boolean isInbetween(BlockPos inside, BlockPos corner1, BlockPos corner2) {
        return BoundingBox.fromCorners((Vec3i)corner1, (Vec3i)corner2).isInside((Vec3i)inside);
    }

    public static BlockPos getNextPosInCircleFrom(BlockPos start, BlockPos corner1, BlockPos corner2, int ringHeight) {
        if (corner1.getX() > corner2.getX() || corner1.getZ() > corner2.getZ() || Math.abs(corner1.getX() - corner2.getX()) < 0 || Math.abs(corner1.getZ() - corner2.getZ()) < 0) {
            Log.getLogger().warn("Insufficient dimensions for:" + String.valueOf(corner1) + String.valueOf(corner2));
            return start;
        }
        int wDist = Math.abs(corner1.getX() - start.getX());
        int nDist = Math.abs(corner1.getZ() - start.getZ());
        int eDist = Math.abs(corner2.getX() - start.getX());
        int sDist = Math.abs(corner2.getZ() - start.getZ());
        Direction closestDir = Direction.NORTH;
        int closest = nDist;
        if (eDist < closest || eDist == closest && closestDir.getClockWise() == Direction.EAST) {
            closest = eDist;
            closestDir = Direction.EAST;
        }
        if (sDist < closest || sDist == closest && closestDir.getClockWise() == Direction.SOUTH) {
            closest = sDist;
            closestDir = Direction.SOUTH;
        }
        if (wDist < closest || wDist == closest && closestDir.getClockWise() == Direction.WEST) {
            closest = wDist;
            closestDir = Direction.WEST;
        }
        int outerRings = Math.min(Math.abs(corner2.getX() - corner1.getX()), Math.abs(corner2.getZ() - corner1.getZ())) >> 1;
        if (closestDir == Direction.WEST && nDist - wDist == 1 && wDist != outerRings) {
            int traverseRow = (start.getY() - corner1.getY() + 1) % ringHeight;
            if (traverseRow != 0) {
                if (start.getY() < corner2.getY()) {
                    return start.relative(Direction.NORTH).offset(0, 1, 0);
                }
                return start.relative(Direction.EAST).offset(0, -(traverseRow - 1), 0);
            }
            return start.relative(Direction.EAST).offset(0, -(ringHeight - 1), 0);
        }
        Direction advancingDir = closestDir.getClockWise();
        BlockPos next = start.relative(advancingDir);
        if (nDist >= outerRings && eDist >= outerRings && sDist >= outerRings && wDist >= outerRings && (Math.abs(corner1.getZ() - next.getZ()) == outerRings || eDist == outerRings && sDist == outerRings && wDist == outerRings) && (advancingDir == Direction.WEST || advancingDir == Direction.NORTH)) {
            if (start.getY() < corner2.getY()) {
                if ((start.getY() - corner1.getY() + 1) % ringHeight != 0) {
                    return new BlockPos(corner1.getX() + outerRings, Math.min(corner2.getY(), start.getY() + 1), corner1.getZ() + outerRings);
                }
                return new BlockPos(corner1.getX(), Math.min(corner2.getY(), start.getY() + 1), corner1.getZ());
            }
            return start;
        }
        return next;
    }

    @Nullable
    public static BlockPos findSafeTeleportPos(@NotNull Level level, @NotNull BlockPos target, boolean falling) {
        BlockPos top = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, target).above(2);
        for (BlockPos start : BlockPos.betweenClosed((BlockPos)target, (BlockPos)top)) {
            if (target.getY() < level.getMinBuildHeight()) continue;
            for (BlockPos pos : BlockPos.spiralAround((BlockPos)start, (int)15, (Direction)Direction.SOUTH, (Direction)Direction.EAST)) {
                if (!level.isEmptyBlock(pos) || !level.isEmptyBlock(pos.above()) || falling && level.isEmptyBlock(pos.below()) && level.isEmptyBlock(pos.below(2)) && level.isEmptyBlock(pos.below(3))) continue;
                return pos;
            }
        }
        return null;
    }
}

