/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage.rendering.types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class BoxPreviewData {
    public static final Codec<BoxPreviewData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.fieldOf("pos1").forGetter(BoxPreviewData::pos1), (App)BlockPos.CODEC.fieldOf("pos2").forGetter(BoxPreviewData::pos2), (App)BlockPos.CODEC.optionalFieldOf("anchor").forGetter(BoxPreviewData::anchor)).apply((Applicative)builder, BoxPreviewData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BoxPreviewData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, BoxPreviewData::pos1, (StreamCodec)BlockPos.STREAM_CODEC, BoxPreviewData::pos2, (StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), BoxPreviewData::anchor, BoxPreviewData::new);
    private final BlockPos pos1;
    private final BlockPos pos2;
    private final Optional<BlockPos> anchor;
    private long expireTime = Long.MAX_VALUE;

    public BoxPreviewData(BlockPos pos1, BlockPos pos2, Optional<BlockPos> anchor) {
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.anchor = anchor;
    }

    public BoxPreviewData withCorners(BlockPos pos1, BlockPos pos2) {
        return new BoxPreviewData(pos1, pos2, this.anchor);
    }

    public BoxPreviewData withAnchor(Optional<BlockPos> anchor) {
        return new BoxPreviewData(this.pos1, this.pos2, anchor);
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.expireTime > 0L;
    }

    public void setExpireTime(int seconds) {
        this.expireTime = System.currentTimeMillis() + (long)(seconds * 1000);
    }

    public BlockPos pos1() {
        return this.pos1;
    }

    public BlockPos pos2() {
        return this.pos2;
    }

    public Optional<BlockPos> anchor() {
        return this.anchor;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BoxPreviewData that = (BoxPreviewData)obj;
        return Objects.equals(this.pos1, that.pos1) && Objects.equals(this.pos2, that.pos2) && Objects.equals(this.anchor, that.anchor);
    }

    public int hashCode() {
        return Objects.hash(this.pos1, this.pos2, this.anchor);
    }

    public String toString() {
        return "BoxPreviewData[pos1=" + String.valueOf(this.pos1) + ", pos2=" + String.valueOf(this.pos2) + ", anchor=" + String.valueOf(this.anchor) + "]";
    }
}

