/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.operations;

import com.ldtteam.structurize.client.gui.util.ItemPositionsStorage;
import com.ldtteam.structurize.operations.AreaOperation;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RemoveFilteredOperation
extends AreaOperation {
    private final List<ItemPositionsStorage> toRemove;

    public RemoveFilteredOperation(ServerPlayer player, List<ItemPositionsStorage> toRemove) {
        super((Component)Component.translatable((String)"com.ldtteam.structurize.remove_blocks"), (Player)player, RemoveFilteredOperation.consolidatePositions(toRemove));
        this.toRemove = toRemove;
    }

    private static List<BlockPos> consolidatePositions(List<ItemPositionsStorage> toRemove) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (ItemPositionsStorage itemPositionsStorage : toRemove) {
            positions.addAll(itemPositionsStorage.positions);
        }
        return new ArrayList<BlockPos>(positions);
    }

    @Override
    protected void apply(ServerLevel world, BlockPos position) {
        for (ItemPositionsStorage itemPositionsStorage : this.toRemove) {
            if (!BlockUtils.doBlocksMatch(itemPositionsStorage.itemStorage.getItemStack(), world, position)) continue;
            this.storage.addPreviousDataFor(position, (Level)world);
            world.removeBlock(position, false);
            this.storage.addPostDataFor(position, (Level)world);
        }
    }
}

