/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.controls.ToggleButton;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.View;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.api.Shape;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.client.gui.AbstractBlueprintManipulationWindow;
import com.ldtteam.structurize.client.gui.WindowSelectRes;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.client.gui.util.ItemUtil;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class WindowShapeTool
extends AbstractBlueprintManipulationWindow {
    private static int width = 1;
    private static int height = 1;
    private static int length = 1;
    private static int frequency = 1;
    private static String equation = "";
    private static boolean hollow = false;
    private static Shape shape = Shape.CUBE;
    private static ItemStack mainBlock = new ItemStack((ItemLike)Blocks.GOLD_BLOCK);
    private static ItemStack secondaryBlock = new ItemStack((ItemLike)Blocks.GOLD_BLOCK);
    private static final String BUTTON_MINUS = "minus";
    private static final String BUTTON_PLUS = "plus";
    private final List<Tuple<Shape, MutableComponent>> sections = new ArrayList<Tuple<Shape, MutableComponent>>();
    private DropDownList sectionsDropDownList;
    private TextField inputWidth;
    private TextField inputLength;
    private TextField inputHeight;
    private TextField inputFrequency;
    private TextField inputShape;
    private int shapeWidth = 1;
    private int shapeLength = 1;
    private int shapeHeight = 1;
    private int shapeFrequency = 1;
    private String shapeequation = "";
    private final HolderLookup.Provider provider;

    public WindowShapeTool(@Nullable BlockPos pos, HolderLookup.Provider provider) {
        super("structurize:gui/windowshapetool.xml", pos, 0, "shapes");
        this.provider = provider;
        this.init(pos, false);
    }

    private void init(BlockPos pos, boolean shouldUpdate) {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData("shapes");
        @Nullable Blueprint structure = previewData.getBlueprint();
        if (structure != null) {
            this.shapeWidth = width;
            this.shapeLength = length;
            this.shapeHeight = height;
            this.shapeFrequency = frequency;
            this.shapeequation = equation;
        }
        this.registerButton("pickMainBlock", this::pickMainBlock);
        this.registerButton("pickFillBlock", this::pickFillBlock);
        this.registerButton("undoredo", (Button b) -> {
            this.close();
            new WindowUndoRedo().open();
        });
        this.registerButton("hollowShape", this::hollowShapeToggle);
        this.inputWidth = (TextField)this.findPaneOfTypeByID("width", TextField.class);
        this.inputLength = (TextField)this.findPaneOfTypeByID("length", TextField.class);
        this.inputHeight = (TextField)this.findPaneOfTypeByID("height", TextField.class);
        this.inputFrequency = (TextField)this.findPaneOfTypeByID("frequency", TextField.class);
        this.inputShape = (TextField)this.findPaneOfTypeByID("shape", TextField.class);
        this.inputWidth.setText(Integer.toString(width));
        this.inputLength.setText(Integer.toString(length));
        this.inputHeight.setText(Integer.toString(height));
        this.inputFrequency.setText(Integer.toString(frequency));
        this.inputShape.setText(equation);
        this.registerButton("widthminus", () -> this.adjust(this.inputWidth, width - 1));
        this.registerButton("widthplus", () -> this.adjust(this.inputWidth, width + 1));
        this.registerButton("lengthminus", () -> this.adjust(this.inputLength, length - 1));
        this.registerButton("lengthplus", () -> this.adjust(this.inputLength, length + 1));
        this.registerButton("heightminus", () -> this.adjust(this.inputHeight, height - 1));
        this.registerButton("heightplus", () -> this.adjust(this.inputHeight, height + 1));
        this.registerButton("frequencyminus", () -> this.adjust(this.inputFrequency, frequency - 1));
        this.registerButton("frequencyplus", () -> this.adjust(this.inputFrequency, frequency + 1));
        this.sections.clear();
        Arrays.stream(Shape.values()).map(s -> new Tuple((Object)s, (Object)Component.translatable((String)("structurize.shapetool.shape." + s.name().toLowerCase())))).forEach(this.sections::add);
        this.sectionsDropDownList = (DropDownList)this.findPaneOfTypeByID("style", DropDownList.class);
        this.sectionsDropDownList.setHandler(this::onDropDownListChanged);
        this.sectionsDropDownList.setDataProvider((DropDownList.DataProvider)new SectionDropDownList());
        this.sectionsDropDownList.setSelectedIndex(shape.ordinal());
        this.registerButton("nextShape", () -> ((DropDownList)this.sectionsDropDownList).selectNext());
        this.registerButton("previousShape", () -> ((DropDownList)this.sectionsDropDownList).selectPrevious());
        this.disableInputIfNecessary();
        if (structure == null || shouldUpdate) {
            this.genShape();
        }
        this.updateRotationState();
        ((ToggleButton)this.findPaneOfTypeByID("hollowShape", ToggleButton.class)).setActiveState(hollow ? "hollow" : "solid");
    }

    private void genShape() {
        RenderingCache.getOrCreateBlueprintPreviewData("shapes").setBlueprint(Manager.getStructureFromFormula(width, length, height, frequency, equation, shape, mainBlock, secondaryBlock, hollow, this.provider));
    }

    private void disableInputIfNecessary() {
        View height = (View)this.findPaneOfTypeByID("heightInput", View.class);
        View width = (View)this.findPaneOfTypeByID("widthInput", View.class);
        View length = (View)this.findPaneOfTypeByID("lengthInput", View.class);
        View frequency = (View)this.findPaneOfTypeByID("frequencyInput", View.class);
        View equation = (View)this.findPaneOfTypeByID("shapeInput", View.class);
        height.show();
        width.show();
        length.show();
        frequency.show();
        equation.hide();
        this.findPaneByID("hollowShape").show();
        this.findPaneByID("pickFillBlock").show();
        this.findPaneByID("resourceIconFill").show();
        if (shape == Shape.SPHERE || shape == Shape.HALF_SPHERE || shape == Shape.BOWL || shape == Shape.PYRAMID || shape == Shape.UPSIDE_DOWN_PYRAMID || shape == Shape.DIAMOND) {
            width.hide();
            length.hide();
            frequency.hide();
        } else if (shape == Shape.CYLINDER || shape == Shape.CONE) {
            length.hide();
            frequency.hide();
        } else if (shape != Shape.WAVE && shape != Shape.WAVE_3D) {
            frequency.hide();
        }
    }

    private void pickMainBlock() {
        new WindowSelectRes(this, (Component)Component.literal((String)"Select the main block"), mainBlock, ItemUtil.getAllItems(), (s, c) -> this.updateBlock((ItemStack)s, true), false, null).open();
    }

    private void pickFillBlock() {
        new WindowSelectRes(this, (Component)Component.literal((String)"Select the main block"), secondaryBlock, ItemUtil.getAllItems(), (s, c) -> this.updateBlock((ItemStack)s, false), false, null).open();
    }

    private void adjust(TextField input, int value) {
        input.setText(Integer.toString(Math.max(1, value)));
        this.onKeyTyped('\u0000', 0);
    }

    private void hollowShapeToggle() {
        ToggleButton hollowButton = (ToggleButton)this.findPaneOfTypeByID("hollowShape", ToggleButton.class);
        hollow = hollowButton.isActiveState("hollow");
        this.genShape();
    }

    @Override
    protected void handlePlacement(BuildToolPlacementMessage.HandlerType type, String id) {
        BlueprintPreviewData previewData = RenderingCache.getOrCreateBlueprintPreviewData("shapes");
        if (previewData.getBlueprint() != null) {
            String packName = Minecraft.getInstance().getUser().getName();
            Path subpath = Path.of("shapes", shape.toString().toLowerCase(Locale.ROOT), mainBlock.getItem().toString().replace(':', '_'), secondaryBlock.getItem().toString().replace(':', '_'), String.format("%dx%dx%dx%d_%c.blueprint", length, width, height, frequency, Character.valueOf(hollow ? (char)'h' : 'f')));
            Path path = Minecraft.getInstance().gameDirectory.toPath().resolve("blueprints").resolve(packName.toLowerCase(Locale.US)).resolve(subpath);
            CompoundTag compound = BlueprintUtil.writeBlueprintToNBT(previewData.getBlueprint());
            ClientFutureProcessor.queueBlueprint(new ClientFutureProcessor.BlueprintProcessingData(StructurePacks.storeBlueprint(packName, compound, path, this.provider), blueprint -> new BuildToolPlacementMessage(type, id, packName, subpath.toString(), previewData.getPos(), RotationMirror.NONE).sendToServer()));
            if (type == BuildToolPlacementMessage.HandlerType.Survival) {
                this.clearAndClose();
            }
        }
    }

    @Override
    protected void cancelClicked() {
        width = 1;
        height = 1;
        length = 1;
        frequency = 1;
        equation = "";
        hollow = false;
        shape = Shape.CUBE;
        mainBlock = new ItemStack((ItemLike)Blocks.GOLD_BLOCK);
        secondaryBlock = new ItemStack((ItemLike)Blocks.GOLD_BLOCK);
        this.clearAndClose();
    }

    private void clearAndClose() {
        RenderingCache.removeBlueprint("shapes");
        this.close();
    }

    @Override
    public void onOpened() {
        ((ItemIcon)this.findPaneOfTypeByID("resourceIconMain", ItemIcon.class)).setItem(mainBlock);
        ((ItemIcon)this.findPaneOfTypeByID("resourceIconFill", ItemIcon.class)).setItem(secondaryBlock);
        ((Button)this.findPaneOfTypeByID("undoredo", Button.class)).setVisible(this.isCreative());
        super.onOpened();
    }

    public void updateBlock(ItemStack stack, boolean isMain) {
        if (isMain) {
            mainBlock = stack;
        } else {
            secondaryBlock = stack;
        }
        ((ItemIcon)this.findPaneOfTypeByID(isMain ? "resourceIconMain" : "resourceIconFill", ItemIcon.class)).setItem(stack);
        this.genShape();
    }

    public boolean isCreative() {
        return Minecraft.getInstance().player.isCreative();
    }

    private void onDropDownListChanged(DropDownList list) {
        if (list == this.sectionsDropDownList) {
            this.updateStyle((Shape)((Object)this.sections.get(this.sectionsDropDownList.getSelectedIndex()).getA()));
        }
    }

    private void updateStyle(Shape newShape) {
        if (newShape != shape) {
            shape = newShape;
            this.genShape();
        }
        this.disableInputIfNecessary();
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        String widthText = this.inputWidth.getText();
        String lengthText = this.inputLength.getText();
        String heightText = this.inputHeight.getText();
        String frequencyText = this.inputFrequency.getText();
        String localequation = this.inputShape.getText();
        if (!(widthText.isEmpty() || lengthText.isEmpty() || heightText.isEmpty())) {
            try {
                int localWidth = Integer.parseInt(widthText);
                int localHeight = Integer.parseInt(heightText);
                int localLength = Integer.parseInt(lengthText);
                int localFrequency = Integer.parseInt(frequencyText);
                if (this.shapeHeight != localHeight || this.shapeLength != localLength || this.shapeWidth != localWidth || this.shapeFrequency != localFrequency || !this.shapeequation.equals(localequation)) {
                    this.shapeWidth = localWidth;
                    this.shapeLength = localLength;
                    this.shapeHeight = localHeight;
                    this.shapeFrequency = localFrequency;
                    this.shapeequation = localequation;
                    width = localWidth;
                    length = localLength;
                    height = localHeight;
                    frequency = localFrequency;
                    equation = localequation;
                    this.genShape();
                }
            }
            catch (NumberFormatException e) {
                this.inputWidth.setText(Integer.toString(width));
                this.inputLength.setText(Integer.toString(length));
                this.inputHeight.setText(Integer.toString(height));
            }
        }
        return result;
    }

    private class SectionDropDownList
    implements DropDownList.DataProvider {
        private SectionDropDownList() {
        }

        public int getElementCount() {
            return WindowShapeTool.this.sections.size();
        }

        public MutableComponent getLabel(int index) {
            return (MutableComponent)WindowShapeTool.this.sections.get(index).getB();
        }
    }
}

