/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.blocks.ModBlocks;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.client.gui.WindowSelectRes;
import com.ldtteam.structurize.client.gui.util.ItemPositionsStorage;
import com.ldtteam.structurize.client.gui.util.ItemUtil;
import com.ldtteam.structurize.network.messages.ReplaceBlockMessage;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowReplaceBlock
extends WindowSelectRes {
    private final ItemPositionsStorage toReplace;

    public WindowReplaceBlock(@Nullable BOWindow origin, @NotNull ItemPositionsStorage toReplace) {
        super(origin, (Component)Component.translatable((String)"com.ldtteam.structurize.gui.replaceblock.info"), toReplace.itemStorage.getItemStack(), ItemUtil.getAllItems(), (stack, integer) -> {}, true, (Component)Component.translatable((String)"com.ldtteam.structurize.gui.scan.replace.pct"));
        this.toReplace = toReplace;
        ((TextField)this.findPaneOfTypeByID("count", TextField.class)).setText("100");
    }

    @Override
    public void onSelectResource(ItemStack to, Integer count) {
        if ((!ItemStackUtils.isEmpty(to) || to.getItem() instanceof AirItem) && this.origin instanceof WindowScan) {
            int pctNum;
            BlockState fromBS = BlockUtils.getBlockStateFromStack(this.toReplace.itemStorage.getItemStack());
            BlockState toBS = BlockUtils.getBlockStateFromStack(to);
            ArrayList missingProperties = new ArrayList(toBS.getProperties());
            missingProperties.removeAll(fromBS.getProperties());
            if (!missingProperties.isEmpty()) {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"structurize.gui.replaceblock.ambiguous_properties", (Object[])new Object[]{fromBS.getBlock().getName(), toBS.getBlock().getName(), missingProperties.stream().map(prop -> this.getPropertyName((Property<?>)prop) + " - " + prop.getName()).collect(Collectors.joining(", ", "[", "]"))}), false);
            }
            if (toBS.is(ModBlocks.NULL_PLACEMENT)) {
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"structurize.gui.replaceblock.null_placement", (Object[])new Object[]{toBS.getBlock().getName()}), false);
            }
            String pct = ((TextField)this.findPaneOfTypeByID("count", TextField.class)).getText();
            try {
                pctNum = Integer.parseInt(pct);
            }
            catch (NumberFormatException ex) {
                pctNum = 100;
                Minecraft.getInstance().player.displayClientMessage((Component)Component.translatable((String)"structurize.gui.replaceblock.badpct"), false);
            }
            new ReplaceBlockMessage(this.toReplace, to, pctNum).sendToServer();
        }
        super.onSelectResource(to, count);
    }

    private String getPropertyName(Property<?> clazz) {
        return clazz instanceof BooleanProperty ? "Boolean" : (clazz instanceof IntegerProperty ? "Integer" : (clazz instanceof EnumProperty ? "Enum" : (clazz instanceof DirectionProperty ? "Direction" : clazz.getClass().getSimpleName())));
    }
}

