/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.client.BlueprintRenderer;
import com.ldtteam.structurize.client.RenderingCacheKey;
import com.ldtteam.structurize.storage.rendering.types.BlueprintPreviewData;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public final class BlueprintHandler {
    private static final BlueprintHandler ourInstance = new BlueprintHandler();
    public static final int CACHE_EXPIRE_SECONDS = 45;
    public static final int CACHE_EXPIRE_CHECK_SECONDS = 15;
    private final LoadingCache<RenderingCacheKey, BlueprintRenderer> rendererCache = CacheBuilder.newBuilder().expireAfterAccess(45L, TimeUnit.SECONDS).removalListener(entry -> ((BlueprintRenderer)entry.getValue()).close()).build((CacheLoader)new CacheLoader<RenderingCacheKey, BlueprintRenderer>(this){

        public BlueprintRenderer load(RenderingCacheKey key) {
            return BlueprintRenderer.buildRendererForBlueprint(key.blueprint());
        }
    });

    private BlueprintHandler() {
    }

    public static BlueprintHandler getInstance() {
        return ourInstance;
    }

    public void draw(BlueprintPreviewData previewData, BlockPos pos, RenderLevelStageEvent ctx) {
        if (previewData == null || previewData.getBlueprint() == null) {
            Log.getLogger().warn("Trying to draw null blueprint!");
            return;
        }
        Minecraft.getInstance().getProfiler().push("struct_render_cache");
        ((BlueprintRenderer)this.rendererCache.getUnchecked((Object)previewData.getRenderKey())).draw(previewData, pos, ctx);
        Minecraft.getInstance().getProfiler().pop();
    }

    public void cleanCache() {
        this.rendererCache.cleanUp();
    }

    public void clearCache() {
        this.rendererCache.invalidateAll();
    }

    public void drawAtListOfPositions(BlueprintPreviewData previewData, Collection<BlockPos> points, RenderLevelStageEvent ctx) {
        if (points.isEmpty() || previewData == null || previewData.getBlueprint() == null) {
            return;
        }
        Minecraft.getInstance().getProfiler().push("struct_render_multi");
        BlueprintRenderer renderer = (BlueprintRenderer)this.rendererCache.getUnchecked((Object)previewData.getRenderKey());
        for (BlockPos coord : points) {
            renderer.draw(previewData, coord, ctx);
        }
        Minecraft.getInstance().getProfiler().pop();
    }

    public List<Entity> getOptionalEntitiesForBlueprint(BlueprintPreviewData previewData) {
        BlueprintRenderer renderer = (BlueprintRenderer)this.rendererCache.getIfPresent((Object)previewData.getRenderKey());
        return renderer == null ? List.of() : renderer.entities;
    }
}

