/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api;

import com.ldtteam.structurize.api.ItemStackUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemStorage {
    private final ItemStack stack;
    private final boolean shouldIgnoreDamageValue;
    private final boolean shouldIgnoreNBTValue;
    private int amount;

    public ItemStorage(ItemStack stack, int amount, boolean ignoreDamageValue, boolean shouldIgnoreNBTValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = shouldIgnoreNBTValue;
        this.amount = amount;
    }

    public ItemStorage(ItemStack stack, boolean ignoreDamageValue, boolean shouldIgnoreNBTValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = shouldIgnoreNBTValue;
    }

    public ItemStorage(ItemStack stack, boolean ignoreDamageValue) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = ignoreDamageValue;
        this.shouldIgnoreNBTValue = ignoreDamageValue;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStorage(ItemStack stack) {
        this.stack = stack;
        this.shouldIgnoreDamageValue = false;
        this.shouldIgnoreNBTValue = false;
        this.amount = ItemStackUtils.getSize(stack);
    }

    public ItemStorage(RegistryFriendlyByteBuf buf) {
        this.stack = ItemStackUtils.deserializeFromBuffer(buf);
        this.shouldIgnoreDamageValue = buf.readBoolean();
        this.shouldIgnoreNBTValue = buf.readBoolean();
        this.amount = buf.readInt();
    }

    public static ItemStorage getItemStackOfListMatchingPredicate(List<ItemStorage> list, Predicate<ItemStack> predicate) {
        for (ItemStorage stack : list) {
            if (!predicate.test(stack.getItemStack())) continue;
            return stack;
        }
        return null;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public boolean ignoreDamageValue() {
        return this.shouldIgnoreDamageValue;
    }

    public boolean ignoreNBTValue() {
        return this.shouldIgnoreNBTValue;
    }

    public int hashCode() {
        return Objects.hash(this.stack.getItem()) + (this.shouldIgnoreDamageValue ? 0 : this.stack.getDamageValue() * 31) + (this.shouldIgnoreNBTValue ? 0 : this.stack.getComponents().hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStorage that = (ItemStorage)o;
        return ItemStackUtils.compareItemStacksIgnoreStackSize(that.getItemStack(), this.getItemStack(), !this.shouldIgnoreDamageValue && !that.shouldIgnoreDamageValue, !this.shouldIgnoreNBTValue && !that.shouldIgnoreNBTValue);
    }

    public Item getItem() {
        return this.stack.getItem();
    }

    public int getDamageValue() {
        return this.stack.getDamageValue();
    }

    public void serialize(RegistryFriendlyByteBuf buf) {
        ItemStackUtils.serializeToBuffer(this.getItemStack(), buf);
        buf.writeBoolean(this.ignoreDamageValue());
        buf.writeBoolean(this.ignoreNBTValue());
        buf.writeInt(this.getAmount());
    }

    public void addAmount(int amount) {
        this.setAmount(this.getAmount() + amount);
    }
}

