/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.stickit.common.networking;

import com.portingdeadmods.stickit.StickIt;
import com.portingdeadmods.stickit.common.networking.CustomCodecs;
import com.portingdeadmods.stickit.common.networking.PayloadBase;
import com.portingdeadmods.stickit.common.registry.RegistryItems;
import com.portingdeadmods.stickit.common.util.EntityUtils;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PlaceItemPayload(BlockHitResult result, int renderType) implements CustomPacketPayload,
PayloadBase
{
    public static final CustomPacketPayload.Type<PlaceItemPayload> TYPE = new CustomPacketPayload.Type(StickIt.rl("place_item_payload"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlaceItemPayload> STREAM_CODEC = StreamCodec.composite(CustomCodecs.BLOCK_HIT_RESULT_STREAM_CODEC, PlaceItemPayload::result, (StreamCodec)ByteBufCodecs.INT, PlaceItemPayload::renderType, PlaceItemPayload::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void action(PlaceItemPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            ItemStack toPlace = new ItemStack((ItemLike)RegistryItems.placed_items, 1);
            ItemStack held = player.getMainHandItem();
            RegistryItems.placed_items.setHeldStack(toPlace, held, payload.renderType);
            EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, toPlace);
            if (toPlace.useOn(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, payload.result)).consumesAction()) {
                ItemStack newHeld = RegistryItems.placed_items.getHeldStack(toPlace);
                EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, newHeld);
            } else {
                EntityUtils.setHeldItemSilent((Player)player, InteractionHand.MAIN_HAND, held);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.literal((String)("Action failed:  " + e.getMessage())));
            return null;
        });
    }
}

