/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.stickit.common.item;

import com.portingdeadmods.stickit.common.config.PlonkConfig;
import com.portingdeadmods.stickit.common.registry.RegistryBlocks;
import com.portingdeadmods.stickit.common.tile.TilePlacedItems;
import com.portingdeadmods.stickit.data.StickItDataComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class ItemBlockPlacedItems
extends BlockItem {
    public ItemBlockPlacedItems(Item.Properties builder) {
        super((Block)RegistryBlocks.placed_items, builder);
    }

    public void setHeldStack(ItemStack stack, ItemStack held, int renderType) {
        NonNullList items = NonNullList.withSize((int)1, (Object)held);
        ItemContainerContents contents = ItemContainerContents.fromItems((List)items);
        stack.set(DataComponents.CONTAINER, (Object)contents);
        stack.set(StickItDataComponents.TAG_RENDER_TYPE, (Object)renderType);
    }

    public ItemStack getHeldStack(ItemStack stack) {
        ItemContainerContents contents = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (contents == null) {
            return ItemStack.EMPTY;
        }
        return contents.copyOne();
    }

    public int getHeldRenderType(ItemStack stack) {
        if (!stack.has(StickItDataComponents.TAG_RENDER_TYPE)) {
            return 0;
        }
        return (Integer)stack.get(StickItDataComponents.TAG_RENDER_TYPE);
    }

    protected boolean tryInsertStack(UseOnContext context, TilePlacedItems tile) {
        ItemStack heldItem = this.getHeldStack(context.getItemInHand());
        int renderType = this.getHeldRenderType(context.getItemInHand());
        ItemStack remainder = tile.insertStack(heldItem, renderType);
        tile.setChanged();
        tile.clean();
        if (remainder != heldItem) {
            this.setHeldStack(context.getItemInHand(), remainder, renderType);
            return true;
        }
        return false;
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack heldStack = this.getHeldStack(context.getItemInHand());
        if (heldStack.isEmpty() || !PlonkConfig.canPlace(heldStack)) {
            return InteractionResult.FAIL;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        TilePlacedItems tile = null;
        if (world.getBlockState(pos).getBlock() == RegistryBlocks.placed_items) {
            tile = (TilePlacedItems)world.getBlockEntity(pos);
        } else {
            BlockPos pos2 = pos.relative(facing);
            if (world.getBlockState(pos2).getBlock() == RegistryBlocks.placed_items) {
                tile = (TilePlacedItems)world.getBlockEntity(pos2);
            }
        }
        Player player = context.getPlayer();
        if (tile != null && this.tryInsertStack(context, tile)) {
            BlockState state = world.getBlockState(pos);
            SoundType soundtype = state.getBlock().getSoundType(state, (LevelReader)world, pos, (Entity)player);
            world.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public boolean placeBlock(BlockPlaceContext context, BlockState newState) {
        ItemStack heldStack = this.getHeldStack(context.getItemInHand());
        if (heldStack.isEmpty()) {
            return false;
        }
        if (!super.placeBlock(context, newState)) {
            return false;
        }
        TilePlacedItems tile = (TilePlacedItems)context.getLevel().getBlockEntity(context.getClickedPos());
        if (tile == null) {
            return false;
        }
        return this.tryInsertStack((UseOnContext)context, tile);
    }
}

