/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.stickit.common.block;

import com.mojang.serialization.MapCodec;
import com.portingdeadmods.stickit.common.registry.RegistryTileEntities;
import com.portingdeadmods.stickit.common.tile.TilePlacedItems;
import com.portingdeadmods.stickit.common.util.ItemUtils;
import com.portingdeadmods.stickit.common.util.WorldUtils;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;

public class BlockPlacedItems
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final ThreadLocal<Boolean> picking = ThreadLocal.withInitial(() -> false);

    public BlockPlacedItems(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return BlockPlacedItems.simpleCodec(BlockPlacedItems::new);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide) {
            return BlockPlacedItems.createTickerHelper(pBlockEntityType, RegistryTileEntities.placed_items, TilePlacedItems::clientTick);
        }
        return BlockPlacedItems.createTickerHelper(pBlockEntityType, RegistryTileEntities.placed_items, TilePlacedItems::serverTick);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return WorldUtils.withTile(worldIn, pos, TilePlacedItems.class, tile -> {
            Entity entity;
            if (this.picking.get().booleanValue()) {
                return tile.getContentsBoxes().getSelectionShape();
            }
            int slot = -1;
            Entity entity2 = entity = context instanceof EntityCollisionContext ? ((EntityCollisionContext)context).getEntity() : null;
            if (entity instanceof Player) {
                slot = this.getPickedSlot((TilePlacedItems)((Object)tile), pos, (Player)entity);
            }
            return slot >= 0 ? tile.getContentsBoxes().getSelectionShapeById(slot + 1) : tile.getContentsBoxes().getSelectionShape();
        }, Shapes::empty);
    }

    @Deprecated
    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return WorldUtils.withTile(worldIn, pos, TilePlacedItems.class, tile -> tile.getContentsBoxes().getCollisionShape(), Shapes::empty);
    }

    @Deprecated
    public VoxelShape getVisualShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity tileentity = worldIn.getBlockEntity(pos);
            if (tileentity instanceof Container) {
                if (!worldIn.restoringBlockSnapshots) {
                    Containers.dropContents((Level)worldIn, (BlockPos)pos, (Container)((Container)tileentity));
                }
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getPickedSlot(TilePlacedItems tile, BlockPos pos, Player player) {
        HitResult traceResult;
        if (this.picking.get().booleanValue()) {
            return -1;
        }
        double blockReachDistance = player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue();
        float partialTicks = 0.0f;
        try {
            this.picking.set(true);
            traceResult = player.pick(blockReachDistance, partialTicks, false);
        }
        finally {
            this.picking.set(false);
        }
        if (traceResult.getType() == HitResult.Type.BLOCK) {
            Vec3 hitVec = traceResult.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            int index = tile.getContentsBoxes().getSelectionIndexFromHitVec(hitVec);
            return index <= 0 ? 0 : index - 1;
        }
        return -1;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        TilePlacedItems tile = (TilePlacedItems)level.getBlockEntity(pos);
        if (tile == null) {
            return ItemInteractionResult.SUCCESS;
        }
        int slot = this.getPickedSlot(tile, pos, player);
        if (slot >= 0) {
            stack = tile.getItem(slot);
            if (!stack.isEmpty()) {
                if (player.isShiftKeyDown()) {
                    tile.rotateSlot(slot);
                } else {
                    ItemUtils.dropItemOnEntity((LivingEntity)player, stack);
                    tile.setItem(slot, ItemStack.EMPTY);
                }
                tile.setChanged();
                tile.clean();
            }
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (placer == null) {
            return;
        }
        TilePlacedItems tile = (TilePlacedItems)worldIn.getBlockEntity(pos);
        Objects.requireNonNull(tile);
        Direction facing = (Direction)worldIn.getBlockState(pos).getValue((Property)FACING);
        float yaw = placer.getYRot() % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        int rotation = Math.round(yaw / 90.0f) % 4;
        rotation = facing == Direction.UP ? (rotation + 2) % 4 : (facing == Direction.DOWN ? 4 - rotation : 0);
        tile.setTileRotation(rotation);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return RegistryTileEntities.placed_items.create(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return WorldUtils.withTile((BlockGetter)level, pos, TilePlacedItems.class, tile -> {
            int slot = this.getPickedSlot((TilePlacedItems)((Object)tile), pos, player);
            return slot >= 0 ? tile.getItem(slot) : ItemStack.EMPTY;
        }, () -> ItemStack.EMPTY);
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel worldserver, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level world, BlockPos pos, Entity entity) {
        return true;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new IClientBlockExtensions(this){

            public boolean addHitEffects(BlockState state, Level Level2, HitResult target, ParticleEngine manager) {
                return true;
            }

            public boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager) {
                return true;
            }
        });
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        return super.getSoundType(state, world, pos, entity);
    }
}

