/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.stickit.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.portingdeadmods.stickit.client.util.RenderUtils;
import com.portingdeadmods.stickit.common.block.BlockPlacedItems;
import com.portingdeadmods.stickit.common.tile.TilePlacedItems;
import com.portingdeadmods.stickit.common.util.MatrixUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class TESRPlacedItems
implements BlockEntityRenderer<TilePlacedItems> {
    public static final DirectionProperty FACING = BlockPlacedItems.FACING;
    private static final Minecraft mc = Minecraft.getInstance();
    private static final ItemRenderer itemRenderer = mc.getItemRenderer();
    private static final double EPS = 0.001;

    public TESRPlacedItems(BlockEntityRendererProvider.Context context) {
    }

    public static int getRenderTypeFromStack(ItemStack itemstack) {
        BakedModel model = itemRenderer.getModel(itemstack, null, null, 0);
        Matrix4f matrixFixed = RenderUtils.getModelTransformMatrix(model, ItemDisplayContext.FIXED);
        Matrix4f matrixGui = RenderUtils.getModelTransformMatrix(model, ItemDisplayContext.GUI);
        Matrix4f difference = MatrixUtils.difference(matrixFixed, matrixGui);
        MatrixUtils.TransformData transform = new MatrixUtils.TransformData(difference);
        double hS = Math.abs((double)(transform.sx + transform.sy + transform.sz) / 3.0);
        double hRotP = (360.0 + transform.pitch) % 90.0;
        hRotP = Math.min(Math.abs(hRotP), Math.abs(hRotP - 90.0));
        double hRotY = (360.0 + transform.yaw) % 90.0;
        hRotY = Math.min(Math.abs(hRotY), Math.abs(hRotY - 90.0));
        double hRotR = (360.0 + transform.roll) % 90.0;
        hRotR = Math.min(Math.abs(hRotR), Math.abs(hRotR - 90.0));
        double hRot = hRotP + hRotY + hRotR;
        double blockRot = 75.0;
        if (74.999 <= hRot && hRot <= 75.001) {
            return 1;
        }
        return 0;
    }

    public void render(TilePlacedItems tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate;
        Direction facing = Direction.UP;
        if (tileEntityIn.hasLevel() && (blockstate = tileEntityIn.getBlockState()).getBlock() instanceof BlockPlacedItems) {
            facing = (Direction)blockstate.getValue((Property)FACING);
        }
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5, 0.5, 0.5);
        switch (facing) {
            case UP: {
                break;
            }
            case DOWN: {
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case SOUTH: {
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case NORTH: {
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                break;
            }
            case WEST: {
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
        }
        matrixStackIn.translate(0.0, -0.5, 0.0);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(-tileEntityIn.getTileRotationAngle())));
        ItemStack[] contents = tileEntityIn.getContentsDisplay();
        TilePlacedItems.ItemMeta[] contentsMeta = tileEntityIn.getContentsMeta();
        int num = contents.length;
        Level level = tileEntityIn.getLevel();
        int seed = (int)tileEntityIn.getBlockPos().asLong();
        if (num > 0) {
            boolean halfSize = num > 1;
            for (int slot = 0; slot < num; ++slot) {
                ItemStack stack = tileEntityIn.getItem(slot);
                if (stack.isEmpty()) continue;
                matrixStackIn.pushPose();
                switch (num) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (slot == 0) {
                            matrixStackIn.translate(-0.25, 0.0, 0.0);
                            break;
                        }
                        matrixStackIn.translate(0.25, 0.0, 0.0);
                        break;
                    }
                    default: {
                        boolean left = slot % 2 == 0;
                        boolean top = slot / 2 == 0;
                        matrixStackIn.translate(left ? -0.25 : 0.25, 0.0, top ? -0.25 : 0.25);
                    }
                }
                this.renderStack(partialTicks, matrixStackIn, bufferIn, combinedLightIn, level, seed + slot, stack, contentsMeta[slot], halfSize);
                matrixStackIn.popPose();
            }
        }
        matrixStackIn.popPose();
    }

    public void renderStack(float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, @Nullable Level level, int seed, ItemStack stack, TilePlacedItems.ItemMeta meta, boolean halfSize) {
        if (stack.isEmpty()) {
            return;
        }
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees((float)(-meta.getRotationAngle())));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(180.0f));
        switch (meta.renderType) {
            case 1: {
                matrixStackIn.translate(0.0f, 0.25f, 0.0f);
                itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, seed);
                break;
            }
            default: {
                matrixStackIn.translate(0.0f, 0.041666668f, 0.0f);
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
                if (halfSize) {
                    matrixStackIn.scale(0.5f, 0.5f, 0.5f);
                }
                itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, level, seed);
            }
        }
        matrixStackIn.popPose();
    }
}

