/*
 * Decompiled with CFR 0.152.
 */
package com.crittafur.statsapi;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class StatsUtils {
    private static final int TICKS_PER_SECOND = 20;

    private StatsUtils() {
    }

    public static String normalizeUuid(String uuid) {
        if (uuid == null || uuid.isEmpty()) {
            return null;
        }
        String cleaned = uuid.toLowerCase().trim();
        if (cleaned.contains("-")) {
            return cleaned;
        }
        if (cleaned.length() != 32) {
            return null;
        }
        if (!cleaned.matches("[a-f0-9]{32}")) {
            return null;
        }
        return cleaned.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
    }

    public static String formatPlaytime(long ticks) {
        if (ticks < 0L) {
            return "0m";
        }
        long totalSeconds = ticks / 20L;
        long hours = totalSeconds / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes);
        }
        return String.format("%dm", minutes);
    }

    public static String formatDistance(long cm) {
        if (cm < 0L) {
            return "0 blocks";
        }
        double blocks = (double)cm / 100.0;
        if (blocks >= 1000.0) {
            return String.format("%.1fkm", blocks / 1000.0);
        }
        return String.format("%.0f blocks", blocks);
    }

    public static Map<String, String> parseQuery(String query) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (query == null || query.isEmpty()) {
            return params;
        }
        for (String param : query.split("&")) {
            String key;
            String[] pair = param.split("=", 2);
            if (pair.length == 2) {
                key = StatsUtils.decodeUrlComponent(pair[0]);
                String value = StatsUtils.decodeUrlComponent(pair[1]);
                if (key == null || key.isEmpty()) continue;
                params.put(key, value);
                continue;
            }
            if (pair.length != 1 || pair[0].isEmpty() || (key = StatsUtils.decodeUrlComponent(pair[0])) == null || key.isEmpty()) continue;
            params.put(key, "");
        }
        return params;
    }

    private static String decodeUrlComponent(String encoded) {
        if (encoded == null) {
            return null;
        }
        try {
            return URLDecoder.decode(encoded, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            return encoded;
        }
    }
}

