/*
 * Decompiled with CFR 0.152.
 */
package com.crittafur.statsapi;

import com.crittafur.statsapi.AdvancementMetadataProvider;
import com.crittafur.statsapi.Config;
import com.crittafur.statsapi.PlayerTracker;
import com.crittafur.statsapi.StatsHttpServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="statsapi")
public class StatsApiMod {
    public static final String MOD_ID = "statsapi";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"StatsAPI");
    private StatsHttpServer httpServer;
    private PlayerTracker playerTracker;
    private MinecraftServer minecraftServer;

    public StatsApiMod(IEventBus modEventBus) {
        LOGGER.info("[Core] Stats API mod initializing...");
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        if (!FMLEnvironment.dist.isDedicatedServer()) {
            LOGGER.info("[Core] Stats API is server-only, skipping client initialization");
            return;
        }
        NeoForge.EVENT_BUS.register((Object)this);
        LOGGER.info("[Core] Stats API mod initialized, waiting for server start...");
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        LOGGER.info("[Core] Server started, launching Stats API...");
        this.applyLogLevel();
        this.minecraftServer = event.getServer();
        this.playerTracker = new PlayerTracker(this.minecraftServer);
        NeoForge.EVENT_BUS.register((Object)this.playerTracker);
        LOGGER.info("[Core] Player session tracker initialized");
        int port = (Integer)Config.SERVER.httpPort.get();
        String bindAddress = (String)Config.SERVER.bindAddress.get();
        int threadPoolSize = (Integer)Config.SERVER.threadPoolSize.get();
        int shutdownTimeout = (Integer)Config.SERVER.shutdownTimeoutSeconds.get();
        String corsOrigins = (String)Config.SERVER.corsAllowedOrigins.get();
        int maxLeaderboard = (Integer)Config.SERVER.maxLeaderboardLimit.get();
        boolean cacheEnabled = (Boolean)Config.SERVER.cacheEnabled.get();
        int realtimeCacheTtl = (Integer)Config.SERVER.realtimeCacheTtlSeconds.get();
        int statsCacheTtl = (Integer)Config.SERVER.statsCacheTtlSeconds.get();
        AdvancementMetadataProvider advancementMetadataProvider = new AdvancementMetadataProvider(this.minecraftServer);
        try {
            this.httpServer = new StatsHttpServer(port, bindAddress, threadPoolSize, shutdownTimeout, corsOrigins, maxLeaderboard, cacheEnabled, realtimeCacheTtl, statsCacheTtl, this.minecraftServer, this.playerTracker, advancementMetadataProvider);
            this.httpServer.start();
            LOGGER.info("[Core] Stats API HTTP server running on {}:{}", (Object)bindAddress, (Object)port);
        }
        catch (Exception e) {
            LOGGER.error("[Core] Failed to start Stats API HTTP server", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("[Core] Server stopping, shutting down Stats API...");
        if (this.playerTracker != null) {
            MinecraftServer server = event.getServer();
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                this.playerTracker.capturePositionForShutdown(player.getUUID().toString(), player.getX(), player.getY(), player.getZ(), player.level().dimension().location().toString());
            }
            NeoForge.EVENT_BUS.unregister((Object)this.playerTracker);
            this.playerTracker.shutdown();
            this.playerTracker = null;
            LOGGER.info("[Core] Player tracker shutdown complete");
        }
        if (this.httpServer != null) {
            this.httpServer.stop();
            this.httpServer = null;
            LOGGER.info("[Core] Stats API HTTP server stopped");
        }
        this.minecraftServer = null;
    }

    private void applyLogLevel() {
        String level = (String)Config.SERVER.logLevel.get();
        Level log4jLevel = Level.toLevel((String)level, (Level)Level.INFO);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("com.crittafur.statsapi");
        if (!loggerConfig.getName().equals("com.crittafur.statsapi")) {
            loggerConfig = new LoggerConfig("com.crittafur.statsapi", log4jLevel, true);
            config.addLogger("com.crittafur.statsapi", loggerConfig);
        } else {
            loggerConfig.setLevel(log4jLevel);
        }
        ctx.updateLoggers();
        LOGGER.info("[Core] Stats API log level set to: {}", (Object)level);
    }
}

