/*
 * Decompiled with CFR 0.152.
 */
package com.crittafur.statsapi;

import java.net.InetAddress;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ModConfigSpec SPEC;
    public static final ServerConfig SERVER;

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        SPEC = (ModConfigSpec)pair.getRight();
        SERVER = (ServerConfig)pair.getLeft();
    }

    public static class ServerConfig {
        public final ModConfigSpec.IntValue httpPort;
        public final ModConfigSpec.ConfigValue<String> bindAddress;
        public final ModConfigSpec.IntValue threadPoolSize;
        public final ModConfigSpec.IntValue shutdownTimeoutSeconds;
        public final ModConfigSpec.ConfigValue<String> corsAllowedOrigins;
        public final ModConfigSpec.IntValue maxLeaderboardLimit;
        public final ModConfigSpec.BooleanValue cacheEnabled;
        public final ModConfigSpec.IntValue realtimeCacheTtlSeconds;
        public final ModConfigSpec.IntValue statsCacheTtlSeconds;
        public final ModConfigSpec.ConfigValue<String> logLevel;
        public final ModConfigSpec.BooleanValue requestLogging;
        public final ModConfigSpec.BooleanValue debugEndpointEnabled;

        ServerConfig(ModConfigSpec.Builder builder) {
            builder.comment("Stats API Server Configuration").push("server");
            this.httpPort = builder.comment("HTTP server port").defineInRange("httpPort", 25580, 1024, 65535);
            this.bindAddress = builder.comment("Bind address (0.0.0.0 for all interfaces, 127.0.0.1 for localhost only)").define("bindAddress", (Object)"0.0.0.0", value -> {
                if (value instanceof String) {
                    String s = (String)value;
                    try {
                        InetAddress.getByName(s);
                        return true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return false;
            });
            this.threadPoolSize = builder.comment("Number of threads for HTTP request handling").defineInRange("threadPoolSize", 4, 1, 32);
            this.shutdownTimeoutSeconds = builder.comment("Seconds to wait for requests to complete on shutdown").defineInRange("shutdownTimeoutSeconds", 2, 1, 30);
            this.corsAllowedOrigins = builder.comment("CORS allowed origins (* for all, or comma-separated list)").define("corsAllowedOrigins", (Object)"*");
            this.maxLeaderboardLimit = builder.comment("Maximum entries returned by leaderboard endpoint").defineInRange("maxLeaderboardLimit", 100, 10, 1000);
            this.cacheEnabled = builder.comment("Enable response caching for HTTP endpoints").define("cacheEnabled", true);
            this.realtimeCacheTtlSeconds = builder.comment("Cache TTL in seconds for real-time endpoints (/health, /players)").defineInRange("realtimeCacheTtlSeconds", 5, 1, 300);
            this.statsCacheTtlSeconds = builder.comment("Cache TTL in seconds for stats endpoints (/stats, /leaderboard)").defineInRange("statsCacheTtlSeconds", 60, 1, 3600);
            this.logLevel = builder.comment("Logging level (ERROR, WARN, INFO, DEBUG, TRACE)").define("logLevel", (Object)"INFO", value -> {
                if (value instanceof String) {
                    String s = (String)value;
                    return s.equals("ERROR") || s.equals("WARN") || s.equals("INFO") || s.equals("DEBUG") || s.equals("TRACE");
                }
                return false;
            });
            this.requestLogging = builder.comment("Enable HTTP request logging").define("requestLogging", false);
            this.debugEndpointEnabled = builder.comment("Enable /debug endpoint for troubleshooting").define("debugEndpointEnabled", false);
            builder.pop();
        }
    }
}

