/*
 * Decompiled with CFR 0.152.
 */
package com.crittafur.statsapi;

import com.crittafur.statsapi.AdvancementsParser;
import com.crittafur.statsapi.StatsUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancementsReader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"StatsAPI");
    private final Path advancementsDirectory;

    public AdvancementsReader(MinecraftServer server) {
        this.advancementsDirectory = server.getWorldPath(LevelResource.PLAYER_ADVANCEMENTS_DIR);
        LOGGER.info("[Advancements] Directory: {}", (Object)this.advancementsDirectory);
    }

    public Map<String, Object> getPlayerAdvancements(String uuidString, boolean includePartial) {
        String normalizedUuid = StatsUtils.normalizeUuid(uuidString);
        Path advancementsFile = this.advancementsDirectory.resolve(normalizedUuid + ".json");
        try {
            return AdvancementsParser.parseAdvancementsFile(advancementsFile, includePartial);
        }
        catch (IOException e) {
            LOGGER.error("[Advancements] Failed to read advancements for {}", (Object)normalizedUuid, (Object)e);
            return null;
        }
    }

    public Set<String> getCompletedAdvancementIds(String uuidString) {
        String normalizedUuid = StatsUtils.normalizeUuid(uuidString);
        Path advancementsFile = this.advancementsDirectory.resolve(normalizedUuid + ".json");
        try {
            if (!Files.exists(advancementsFile, new LinkOption[0])) {
                return Set.of();
            }
            long fileSize = Files.size(advancementsFile);
            if (fileSize > 0xA00000L) {
                return Set.of();
            }
            String content = Files.readString(advancementsFile);
            return AdvancementsParser.getCompletedAdvancementIds(content);
        }
        catch (IOException e) {
            LOGGER.error("[Advancements] Failed to read advancements for {}", (Object)normalizedUuid, (Object)e);
            return Set.of();
        }
    }
}

