/*
 * Decompiled with CFR 0.152.
 */
package com.crittafur.statsapi;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancementMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"StatsAPI");
    private final Map<String, AdvancementMetadata> metadataMap;

    public AdvancementMetadataProvider(MinecraftServer server) {
        ServerAdvancementManager manager = server.getAdvancements();
        HashMap<String, AdvancementMetadata> map = new HashMap<String, AdvancementMetadata>();
        for (AdvancementHolder holder : manager.getAllAdvancements()) {
            String id = holder.id().toString();
            Advancement adv = holder.value();
            if (adv.display().isEmpty()) continue;
            DisplayInfo display = (DisplayInfo)adv.display().get();
            String title = display.getTitle().getString();
            String description = display.getDescription().getString();
            String icon = display.getIcon().getItem().toString();
            String frame = display.getType().getSerializedName();
            map.put(id, new AdvancementMetadata(title, description, icon, frame));
        }
        this.metadataMap = Map.copyOf(map);
        LOGGER.info("[Advancements] Loaded metadata for {} advancements", (Object)this.metadataMap.size());
    }

    public AdvancementMetadata getMetadata(String advancementId) {
        return this.metadataMap.get(advancementId);
    }

    public record AdvancementMetadata(String title, String description, String icon, String frame) {
    }
}

