/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.tournament;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.SingleStackContainer;
import com.wdiscute.starcatcher.tournament.TournamentPlayerScore;
import com.wdiscute.starcatcher.tournament.TournamentSettings;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public record Tournament(String name, Status status, UUID owner, Map<UUID, TournamentPlayerScore> players, TournamentSettings settings, List<SingleStackContainer> pool, long lastsUntil) {
    public static final Codec<Tournament> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("name", (Object)"Unnamed Tournament").forGetter(Tournament::name), (App)Status.CODEC.fieldOf("status").forGetter(Tournament::status), (App)UUIDUtil.CODEC.fieldOf("owner").forGetter(Tournament::owner), (App)Codec.unboundedMap((Codec)UUIDUtil.CODEC, TournamentPlayerScore.CODEC).fieldOf("player_scores").forGetter(Tournament::players), (App)TournamentSettings.CODEC.fieldOf("settings").forGetter(Tournament::settings), (App)SingleStackContainer.LIST_CODEC.optionalFieldOf("legendary", SingleStackContainer.EMPTY_LIST).forGetter(Tournament::pool), (App)Codec.LONG.fieldOf("lastsUntil").forGetter(Tournament::lastsUntil)).apply((Applicative)instance, Tournament::new));

    public void addScore(Player player, FishProperties fp, boolean perfectCatch) {
    }

    public static enum Status implements StringRepresentable
    {
        SETUP("setup"),
        ACTIVE("active"),
        FINISHED("finished");

        public static final Codec<Status> CODEC;
        public static final Codec<List<Status>> LIST_CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, Status> STREAM_CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, List<Status>> LIST_STREAM_CODEC;
        private final String key;

        private Status(String name) {
            this.key = name;
        }

        public String toString() {
            return this.key;
        }

        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Status::values);
            LIST_CODEC = CODEC.listOf();
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Status.class);
            LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
        }
    }
}

