/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandcodecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.networkandcodecs.ExtraComposites;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public record FishCaughtCounter(FishProperties fp, int count, int fastestTicks, float averageTicks, int size, int weight, boolean caughtGolden, boolean perfectCatch) {
    public static final Codec<FishCaughtCounter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FishProperties.CODEC.fieldOf("fps").forGetter(FishCaughtCounter::fp), (App)Codec.INT.optionalFieldOf("count", (Object)0).forGetter(FishCaughtCounter::count), (App)Codec.INT.optionalFieldOf("fastest_ticks", (Object)0).forGetter(FishCaughtCounter::fastestTicks), (App)Codec.FLOAT.optionalFieldOf("average_ticks", (Object)Float.valueOf(0.0f)).forGetter(FishCaughtCounter::averageTicks), (App)Codec.INT.optionalFieldOf("best_size", (Object)0).forGetter(FishCaughtCounter::size), (App)Codec.INT.optionalFieldOf("best_weight", (Object)0).forGetter(FishCaughtCounter::weight), (App)Codec.BOOL.optionalFieldOf("caught_golden", (Object)false).forGetter(FishCaughtCounter::caughtGolden), (App)Codec.BOOL.optionalFieldOf("perfect_catch", (Object)false).forGetter(FishCaughtCounter::caughtGolden)).apply((Applicative)instance, FishCaughtCounter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FishCaughtCounter> STREAM_CODEC = ExtraComposites.composite(FishProperties.STREAM_CODEC, FishCaughtCounter::fp, ByteBufCodecs.VAR_INT, FishCaughtCounter::count, ByteBufCodecs.VAR_INT, FishCaughtCounter::fastestTicks, ByteBufCodecs.FLOAT, FishCaughtCounter::averageTicks, ByteBufCodecs.INT, FishCaughtCounter::size, ByteBufCodecs.INT, FishCaughtCounter::weight, ByteBufCodecs.BOOL, FishCaughtCounter::caughtGolden, ByteBufCodecs.BOOL, FishCaughtCounter::perfectCatch, FishCaughtCounter::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, List<FishCaughtCounter>> LIST_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs.list());
    public static final Codec<List<FishCaughtCounter>> LIST_CODEC = CODEC.listOf();

    public static int getRandomSize(FishProperties fp) {
        return (int)Starcatcher.truncatedNormal(fp.sw().sizeAverage(), fp.sw().sizeDeviation());
    }

    public static int getRandomWeight(FishProperties fp) {
        return (int)Starcatcher.truncatedNormal(fp.sw().weightAverage(), fp.sw().weightDeviation());
    }

    public static void AwardFishCaughtCounter(FishProperties fpCaught, Player player, int ticks, int size, int weight, boolean perfectCatch) {
        List listFishCaughtCounter = (List)player.getData(ModDataAttachments.FISHES_CAUGHT);
        ArrayList<FishCaughtCounter> newlist = new ArrayList<FishCaughtCounter>();
        boolean newFish = true;
        for (FishCaughtCounter fcc : listFishCaughtCounter) {
            if (fpCaught.equals(fcc.fp)) {
                boolean perfect;
                int fastestToSave = Math.min(fcc.fastestTicks, ticks);
                float averageToSave = (fcc.averageTicks * (float)fcc.count + (float)ticks) / (float)(fcc.count + 1);
                int countToSave = fcc.count;
                boolean bl = perfect = perfectCatch || fcc.perfectCatch;
                if (fcc.fastestTicks == 0) {
                    fastestToSave = ticks;
                }
                if (fcc.averageTicks == 0.0f) {
                    averageToSave = ticks;
                }
                if (fcc.count == 999999) {
                    countToSave = 0;
                }
                int sizeToSave = Math.max(size, fcc.size);
                int weightToSave = Math.max(weight, fcc.weight);
                newlist.add(new FishCaughtCounter(fpCaught, countToSave + 1, fastestToSave, averageToSave, sizeToSave, weightToSave, false, perfect));
                newFish = false;
                continue;
            }
            newlist.add(fcc);
        }
        if (newFish) {
            newlist.add(new FishCaughtCounter(fpCaught, 1, ticks, ticks, size, weight, false, perfectCatch));
        }
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new Payloads.FishCaughtPayload(fpCaught, newFish, size, weight), (CustomPacketPayload[])new CustomPacketPayload[0]);
        player.setData(ModDataAttachments.FISHES_CAUGHT, newlist);
    }
}

