/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.brokenbottle;

import com.wdiscute.starcatcher.ModEntities;
import com.wdiscute.starcatcher.ModItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class BottleEntity
extends ThrowableItemProjectile {
    public BottleEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public BottleEntity(Level level, LivingEntity shooter) {
        super(ModEntities.BOTTLE.get(), shooter, level);
    }

    public BottleEntity(Level level, double x, double y, double z) {
        super(ModEntities.BOTTLE.get(), x, y, z, level);
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.BROKEN_BOTTLE.get();
    }

    private ParticleOptions getParticle() {
        ItemStack itemstack = this.getItem();
        return new ItemParticleOption(ParticleTypes.ITEM, itemstack);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GLASS_BREAK, SoundSource.NEUTRAL, 0.5f, (float)(1.0 + (double)this.level().getRandom().nextFloat() * 0.3 + 0.15));
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 5.0f);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GLASS_BREAK, SoundSource.NEUTRAL, 0.5f, (float)(1.0 + (double)this.level().getRandom().nextFloat() * 0.3 + 0.15));
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }
}

