/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.bob;

import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.ModEntities;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.ModParticles;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.networkandcodecs.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.SingleStackContainer;
import com.wdiscute.starcatcher.networkandcodecs.SizeAndWeight;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishingBobEntity
extends Projectile {
    private static final Logger log = LoggerFactory.getLogger(FishingBobEntity.class);
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(FishingBobEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final Player player;
    private FishHookState currentState;
    public FishProperties fpToFish;
    public ItemStack rod = ItemStack.EMPTY;
    public ItemStack bobber = ItemStack.EMPTY;
    public ItemStack hook = ItemStack.EMPTY;
    public ItemStack bait = ItemStack.EMPTY;
    int minTicksToFish;
    int maxTicksToFish;
    int chanceToFishEachTick;
    int timeBiting;
    int ticksInFluid;

    public FishingBobEntity(EntityType<? extends FishingBobEntity> entityType, Level level) {
        super(entityType, level);
        this.player = null;
    }

    public FishingBobEntity(Level level, Player player, ItemStack rod) {
        super(ModEntities.FISHING_BOB.get(), level);
        this.player = player;
        this.rod = rod;
        this.bobber = ((SingleStackContainer)rod.get(ModDataComponents.BOBBER)).stack().copy();
        this.bait = ((SingleStackContainer)rod.get(ModDataComponents.BAIT)).stack().copy();
        this.hook = ((SingleStackContainer)rod.get(ModDataComponents.HOOK)).stack().copy();
        this.setOwner((Entity)player);
        this.minTicksToFish = 100;
        this.maxTicksToFish = 300;
        this.chanceToFishEachTick = 100;
        if (this.bobber.is(ModItems.IMPATIENT_BOBBER)) {
            this.chanceToFishEachTick = 20;
        }
        if (this.bobber.is(ModItems.IMPATIENT_BOBBER)) {
            this.minTicksToFish = 80;
        }
        float f = player.getXRot();
        float f1 = player.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.getX() - (double)f3 * 0.3;
        double d1 = player.getEyeY();
        double d2 = player.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply(0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement(vec3);
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 180.0 / 3.1415927410125732));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        if (!level.isClientSide) {
            player.setData(ModDataAttachments.FISHING.get(), (Object)this.uuid.toString());
        }
        this.currentState = FishHookState.FLYING;
    }

    public void reel() {
        boolean skipsMinigame;
        ArrayList<FishProperties> available = new ArrayList<FishProperties>(List.of());
        ArrayList<TrophyProperties> trophiesCaught = new ArrayList<TrophyProperties>((Collection)this.player.getData(ModDataAttachments.TROPHIES_CAUGHT));
        TrophyProperties.RarityProgress all = new TrophyProperties.RarityProgress(0, ((List)this.player.getData(ModDataAttachments.FISHES_CAUGHT)).size() - 1);
        TrophyProperties.RarityProgress common = new TrophyProperties.RarityProgress(0, -1);
        TrophyProperties.RarityProgress uncommon = TrophyProperties.RarityProgress.DEFAULT;
        TrophyProperties.RarityProgress rare = TrophyProperties.RarityProgress.DEFAULT;
        TrophyProperties.RarityProgress epic = TrophyProperties.RarityProgress.DEFAULT;
        TrophyProperties.RarityProgress legendary = TrophyProperties.RarityProgress.DEFAULT;
        for (FishCaughtCounter fcc : (List)this.player.getData(ModDataAttachments.FISHES_CAUGHT)) {
            all = new TrophyProperties.RarityProgress(all.total() + fcc.count(), all.unique());
            if (fcc.fp().rarity() == FishProperties.Rarity.COMMON) {
                common = new TrophyProperties.RarityProgress(common.total() + fcc.count(), common.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.UNCOMMON) {
                uncommon = new TrophyProperties.RarityProgress(uncommon.total() + fcc.count(), uncommon.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.RARE) {
                rare = new TrophyProperties.RarityProgress(rare.total() + fcc.count(), rare.unique() + 1);
            }
            if (fcc.fp().rarity() == FishProperties.Rarity.EPIC) {
                epic = new TrophyProperties.RarityProgress(epic.total() + fcc.count(), epic.unique() + 1);
            }
            if (fcc.fp().rarity() != FishProperties.Rarity.LEGENDARY) continue;
            legendary = new TrophyProperties.RarityProgress(legendary.total() + fcc.count(), legendary.unique() + 1);
        }
        for (TrophyProperties tp : this.level().registryAccess().registryOrThrow(Starcatcher.TROPHY_REGISTRY)) {
            if (!FishingBobEntity.check(all, tp.all()) || !FishingBobEntity.check(common, tp.common()) || !FishingBobEntity.check(uncommon, tp.uncommon()) || !FishingBobEntity.check(rare, tp.rare()) || !FishingBobEntity.check(epic, tp.epic()) || !FishingBobEntity.check(legendary, tp.legendary()) || trophiesCaught.contains(tp) || FishProperties.getChance(tp.fp(), (Entity)this, new ItemStack((ItemLike)ModItems.ROD.get())) <= 0 || this.random.nextIntBetweenInclusive(0, 99) >= tp.chanceToCatch()) continue;
            ItemStack is = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(tp.fp().fish().getKey()));
            is.set(ModDataComponents.TROPHY, (Object)tp);
            if (!tp.customName().isEmpty()) {
                is.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)tp.customName()));
            }
            ItemEntity itemFished = new ItemEntity(this.level(), this.position().x, this.position().y + (double)1.2f, this.position().z, is);
            Vec3 vec3 = new Vec3(Math.clamp((this.player.position().x - this.position().x) / 25.0, -1.0, 1.0), 0.7 + Math.clamp((this.player.position().y - this.position().y) / 20.0, -1.0, 1.0), Math.clamp((this.player.position().z - this.position().z) / 25.0, -1.0, 1.0));
            itemFished.setDeltaMovement(vec3);
            this.level().addFreshEntity((Entity)itemFished);
            trophiesCaught.add(tp);
            this.player.setData(ModDataAttachments.TROPHIES_CAUGHT, trophiesCaught);
            this.player.setData(ModDataAttachments.FISHING, (Object)"");
            this.kill();
            return;
        }
        for (FishProperties fp : this.level().registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY)) {
            int chance = FishProperties.getChance(fp, (Entity)this, this.rod);
            for (int i = 0; i < chance; ++i) {
                available.add(fp);
            }
        }
        if (available.isEmpty()) {
            this.player.setData(ModDataAttachments.FISHING, (Object)"");
            this.discard();
        }
        this.fpToFish = (FishProperties)available.get(this.random.nextInt(available.size()));
        boolean bl = skipsMinigame = this.fpToFish.skipMinigame() || this.bobber.is(ModItems.CREEPER_BOBBER) && (double)this.random.nextFloat() > 0.8;
        if (!((Boolean)Config.ENABLE_MINIGAME.get()).booleanValue()) {
            skipsMinigame = true;
        }
        if (skipsMinigame) {
            ItemStack is = new ItemStack(this.fpToFish.fish());
            if (!((Boolean)Config.ENABLE_MINIGAME.get()).booleanValue() && !this.fpToFish.skipMinigame()) {
                int size = FishCaughtCounter.getRandomSize(this.fpToFish);
                int weight = FishCaughtCounter.getRandomWeight(this.fpToFish);
                is.set(ModDataComponents.SIZE_AND_WEIGHT, (Object)new SizeAndWeight(size, weight));
                FishCaughtCounter.AwardFishCaughtCounter(this.fpToFish, this.player, 0, size, weight, false);
            }
            ItemEntity itemFished = new ItemEntity(this.level(), this.position().x, this.position().y + (double)1.2f, this.position().z, is);
            double x = (this.player.position().x - this.position().x) / 25.0;
            double y = (this.player.position().y - this.position().y) / 20.0;
            double z = (this.player.position().z - this.position().z) / 25.0;
            x = Math.clamp(x, -1.0, 1.0);
            y = Math.clamp(y, -1.0, 1.0);
            z = Math.clamp(z, -1.0, 1.0);
            if (this.bobber.is(ModItems.CREEPER_BOBBER)) {
                itemFished = new Creeper(EntityType.CREEPER, this.level());
                itemFished.setPos(this.position().add(0.0, (double)1.2f, 0.0));
                x *= 2.5;
                y *= 2.0;
                z *= 2.5;
            }
            Vec3 vec3 = new Vec3(x, 0.7 + y, z);
            itemFished.setDeltaMovement(vec3);
            this.level().addFreshEntity((Entity)itemFished);
            this.player.setData(ModDataAttachments.FISHING, (Object)"");
            this.kill();
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new Payloads.FishingPayload(this.fpToFish, this.rod), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if (this.fpToFish.br().consumesBait()) {
            if (this.bobber.is(ModItems.FRUGAL_BOBBER)) {
                if (this.random.nextFloat() > 0.8f) {
                    this.bait.setCount(this.bait.getCount() - 1);
                }
            } else {
                this.bait.setCount(this.bait.getCount() - 1);
            }
            this.rod.set(ModDataComponents.BAIT, (Object)new SingleStackContainer(this.bait));
        }
    }

    private boolean shouldStopFishing(Player player) {
        boolean holdingRod;
        if (this.level().isClientSide) {
            return false;
        }
        boolean bl = holdingRod = player.getMainHandItem().is(ModItems.ROD) || player.getOffhandItem().is(ModItems.ROD);
        if (!player.isRemoved() && player.isAlive() && holdingRod && !(this.distanceToSqr((Entity)player) > 1024.0)) {
            return false;
        }
        player.setData(ModDataAttachments.FISHING.get(), (Object)"");
        this.discard();
        return true;
    }

    public boolean fireImmune() {
        return this.hook.is(StarcatcherTags.HOOKS_SURVIVE_FIRE);
    }

    public void lavaHurt() {
        super.lavaHurt();
        if (!this.hook.is(StarcatcherTags.HOOKS_SURVIVE_FIRE) && !this.level().isClientSide) {
            this.player.setData(ModDataAttachments.FISHING, (Object)"");
            this.kill();
        }
    }

    public void tick() {
        Player player;
        super.tick();
        if (!this.level().isClientSide) {
            if (this.currentState == FishHookState.FLYING) {
                this.entityData.set(STATE, (Object)1);
            }
            if (this.currentState == FishHookState.BOBBING) {
                this.entityData.set(STATE, (Object)2);
            }
            if (this.currentState == FishHookState.BITING) {
                this.entityData.set(STATE, (Object)3);
            }
            if (this.currentState == FishHookState.FISHING) {
                this.entityData.set(STATE, (Object)4);
            }
        } else {
            if ((Integer)this.entityData.get(STATE) == 1) {
                this.currentState = FishHookState.FLYING;
            }
            if ((Integer)this.entityData.get(STATE) == 2) {
                this.currentState = FishHookState.BOBBING;
            }
            if ((Integer)this.entityData.get(STATE) == 3) {
                this.currentState = FishHookState.BITING;
            }
            if ((Integer)this.entityData.get(STATE) == 4) {
                this.currentState = FishHookState.FISHING;
            }
        }
        if ((player = (Player)this.getOwner()) == null || this.shouldStopFishing(player)) {
            this.discard();
            if (player != null) {
                player.setData(ModDataAttachments.FISHING.get(), (Object)"");
            }
        }
        BlockPos blockpos = this.blockPosition();
        FluidState fluid = this.level().getFluidState(blockpos);
        FluidState fluidBellow = this.level().getFluidState(blockpos.below());
        if (this.currentState == FishHookState.FLYING) {
            if (this.getDeltaMovement().y < (double)1.2f) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.02, 0.0));
            }
            if (!fluid.isEmpty()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.3, 0.3));
                if (!this.level().isClientSide) {
                    this.currentState = FishHookState.BOBBING;
                }
                return;
            }
        }
        if (this.currentState == FishHookState.BITING) {
            ++this.timeBiting;
            for (int i = 0; i < 5; ++i) {
                if (this.level().getFluidState(blockpos).is((Fluid)Fluids.LAVA)) {
                    this.level().addParticle((ParticleOptions)ModParticles.FISHING_BITING_LAVA.get(), this.position().x + (double)this.random.nextFloat() - 0.5, this.position().y + (double)this.random.nextFloat() * 0.5 - 0.25, this.position().z + (double)this.random.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                    continue;
                }
                this.level().addParticle((ParticleOptions)ModParticles.FISHING_BITING.get(), this.position().x + (double)this.random.nextFloat() - 0.5, this.position().y + (double)this.random.nextFloat() * 0.5 - 0.25, this.position().z + (double)this.random.nextFloat() - 0.5, 0.0, 0.0, 0.0);
            }
            if (this.timeBiting > 80) {
                player.setData(ModDataAttachments.FISHING, (Object)"");
                this.kill();
            }
        } else {
            this.timeBiting = 0;
        }
        if (fluid.isEmpty() && fluidBellow.isEmpty() && !this.level().isClientSide) {
            this.currentState = FishHookState.FLYING;
        }
        if (this.currentState == FishHookState.BOBBING || this.currentState == FishHookState.FISHING) {
            this.checkForFish();
            if (!fluid.isEmpty()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.01, 0.0));
            } else if ((double)this.random.nextFloat() > 0.02) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            } else {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.01, 0.0));
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround() || this.horizontalCollision) {
            this.setDeltaMovement(Vec3.ZERO);
        }
        this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
        this.reapplyPosition();
    }

    public boolean checkBiting() {
        if (this.currentState == FishHookState.BITING) {
            this.currentState = FishHookState.FISHING;
            this.reel();
            return true;
        }
        return false;
    }

    private void checkForFish() {
        if (!this.level().isClientSide && this.currentState == FishHookState.BOBBING) {
            ++this.ticksInFluid;
            int i = this.random.nextInt(this.chanceToFishEachTick);
            if ((i == 1 || this.ticksInFluid > this.maxTicksToFish) && this.ticksInFluid > this.minTicksToFish) {
                if (((Boolean)Config.SHOW_EXCLAMATION_MARK_PARTICLE.get()).booleanValue()) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ModParticles.FISHING_NOTIFICATION.get(), this.position().x, this.position().y + 1.0, this.position().z, 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.setPos(this.position().x, this.position().y - 0.5, this.position().z);
                if (!this.level().isClientSide) {
                    this.currentState = FishHookState.BITING;
                }
                this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            }
        }
    }

    public AABB getBoundingBoxForCulling() {
        AABB box = new AABB(-10.0, -10.0, -10.0, 10.0, 10.0, 10.0);
        return box.move(this.position());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STATE, (Object)0);
    }

    public static boolean check(TrophyProperties.RarityProgress current, TrophyProperties.RarityProgress restriction) {
        return current.total() >= restriction.total() && current.unique() >= restriction.unique();
    }

    static enum FishHookState {
        FLYING,
        BOBBING,
        BITING,
        FISHING;

    }
}

