/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.blocks;

import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.blocks.StandBlock;
import com.wdiscute.starcatcher.blocks.StandBlockItem;
import com.wdiscute.starcatcher.blocks.TrophyBlock;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public interface ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"starcatcher");
    public static final DeferredBlock<Block> TROPHY_GOLD = ModBlocks.registerBlock("trophy_gold", TrophyBlock::new);
    public static final DeferredBlock<Block> TROPHY_SILVER = ModBlocks.registerBlock("trophy_silver", TrophyBlock::new);
    public static final DeferredBlock<Block> TROPHY_BRONZE = ModBlocks.registerStand("trophy_bronze", TrophyBlock::new);
    public static final DeferredBlock<Block> STAND = ModBlocks.registerBlock("tournament_stand", StandBlock::new);

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerStand(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModItems.ITEMS.register(name, () -> new StandBlockItem((Block)toReturn.get()));
        return toReturn;
    }

    private static <T extends Block> void registerStandBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new StandBlockItem((Block)block.get()));
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

