/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher;

import com.wdiscute.libtooltips.Tooltips;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.ModCreativeModeTabs;
import com.wdiscute.starcatcher.ModEntities;
import com.wdiscute.starcatcher.ModItemProperties;
import com.wdiscute.starcatcher.ModItems;
import com.wdiscute.starcatcher.ModMenuTypes;
import com.wdiscute.starcatcher.ModParticles;
import com.wdiscute.starcatcher.ModSounds;
import com.wdiscute.starcatcher.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.blocks.ModBlocks;
import com.wdiscute.starcatcher.bob.FishingBobModel;
import com.wdiscute.starcatcher.bob.FishingBobRenderer;
import com.wdiscute.starcatcher.fishentity.FishEntity;
import com.wdiscute.starcatcher.fishentity.FishRenderer;
import com.wdiscute.starcatcher.fishentity.fishmodels.AgaveBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.BigeyeTuna;
import com.wdiscute.starcatcher.fishentity.fishmodels.Boreal;
import com.wdiscute.starcatcher.fishentity.fishmodels.CactiFish;
import com.wdiscute.starcatcher.fishentity.fishmodels.Charfish;
import com.wdiscute.starcatcher.fishentity.fishmodels.CrystalbackBoreal;
import com.wdiscute.starcatcher.fishentity.fishmodels.CrystalbackMinnow;
import com.wdiscute.starcatcher.fishentity.fishmodels.DeepjawHerring;
import com.wdiscute.starcatcher.fishentity.fishmodels.DownfallBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.Driftfin;
import com.wdiscute.starcatcher.fishentity.fishmodels.DriftingBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.DusktailSnapper;
import com.wdiscute.starcatcher.fishentity.fishmodels.LilySnapper;
import com.wdiscute.starcatcher.fishentity.fishmodels.PinkKoi;
import com.wdiscute.starcatcher.fishentity.fishmodels.SilverveilPerch;
import com.wdiscute.starcatcher.fishentity.fishmodels.SludgeCatfish;
import com.wdiscute.starcatcher.fishentity.fishmodels.Whiteveil;
import com.wdiscute.starcatcher.fishentity.fishmodels.WillowBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.WinteryPike;
import com.wdiscute.starcatcher.fishspotter.FishTrackerLayer;
import com.wdiscute.starcatcher.guide.FishCaughtToast;
import com.wdiscute.starcatcher.guide.SettingsScreen;
import com.wdiscute.starcatcher.networkandcodecs.FishProperties;
import com.wdiscute.starcatcher.networkandcodecs.ModDataAttachments;
import com.wdiscute.starcatcher.networkandcodecs.ModDataComponents;
import com.wdiscute.starcatcher.networkandcodecs.PayloadReceiver;
import com.wdiscute.starcatcher.networkandcodecs.Payloads;
import com.wdiscute.starcatcher.networkandcodecs.SizeAndWeight;
import com.wdiscute.starcatcher.networkandcodecs.TrophyProperties;
import com.wdiscute.starcatcher.particles.FishingBitingLavaParticles;
import com.wdiscute.starcatcher.particles.FishingBitingParticles;
import com.wdiscute.starcatcher.particles.FishingNotificationParticles;
import com.wdiscute.starcatcher.rod.FishingRodScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@Mod(value="starcatcher")
public class Starcatcher {
    public static final String MOD_ID = "starcatcher";
    public static final ResourceKey<Registry<FishProperties>> FISH_REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("fish"));
    public static final ResourceKey<Registry<TrophyProperties>> TROPHY_REGISTRY = ResourceKey.createRegistryKey((ResourceLocation)Starcatcher.rl("trophy"));
    public static final Random r = new Random();

    public static double truncatedNormal(double mean, double deviation) {
        double value;
        while (!((value = mean + deviation * r.nextGaussian()) >= mean - deviation) || !(value <= mean + deviation)) {
        }
        return value;
    }

    public static ResourceLocation rl(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)s);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fishCaughtToast(FishProperties fp, boolean newFish, int sizeCM, int weightCM) {
        if (newFish) {
            Minecraft.getInstance().getToasts().addToast((Toast)new FishCaughtToast(fp));
        }
        SettingsScreen.Units units = (SettingsScreen.Units)((Object)Config.UNIT.get());
        String size = units.getSizeAsString(sizeCM);
        String weight = units.getWeightAsString(weightCM);
        Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"").append((Component)Component.translatable((String)((Item)fp.fish().getDelegate().value()).getDescriptionId())).append((Component)Component.literal((String)(" - " + size + " - " + weight))), true);
        Minecraft.getInstance().gui.overlayMessageTime = 180;
    }

    public Starcatcher(IEventBus modEventBus, ModContainer modContainer) {
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModDataComponents.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModParticles.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModDataAttachments.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC_SERVER);
    }

    @OnlyIn(value=Dist.CLIENT)
    @EventBusSubscriber(modid="starcatcher", value={Dist.CLIENT})
    public static class ModClientEvents {
        @SubscribeEvent
        public static void trophyTooltip(ItemTooltipEvent event) {
            TrophyProperties tp;
            List comp = event.getToolTip();
            ItemStack stack = event.getItemStack();
            if (stack.has(ModDataComponents.SIZE_AND_WEIGHT)) {
                SizeAndWeight sw = (SizeAndWeight)stack.get(ModDataComponents.SIZE_AND_WEIGHT);
                SettingsScreen.Units units = (SettingsScreen.Units)((Object)Config.UNIT.get());
                String size = units.getSizeAsString(sw.sizeInCentimeters());
                String weight = units.getWeightAsString(sw.weightInGrams());
                comp.add(1, Component.literal((String)(size + " - " + weight)).withColor(0x888888));
            }
            if (stack.has(ModDataComponents.TROPHY) && (tp = (TrophyProperties)stack.get(ModDataComponents.TROPHY)).trophyType() == TrophyProperties.TrophyType.TROPHY) {
                if (event.getFlags().hasShiftDown()) {
                    comp.add(Component.translatable((String)"tooltip.libtooltips.generic.shift_down"));
                    comp.add(Component.translatable((String)"tooltip.libtooltips.generic.empty"));
                    comp.add(Component.translatable((String)"tooltip.starcatcher.trophy.0"));
                    comp.add(Component.translatable((String)"tooltip.starcatcher.trophy.1"));
                    ArrayList<Component> list = new ArrayList<Component>();
                    if (tp.all().total() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.all().total()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.all", (Object[])new Object[0]))));
                    }
                    if (tp.all().unique() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.all().unique()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.all", (Object[])new Object[0]))));
                    }
                    if (tp.common().total() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.common().total()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.common", (Object[])new Object[0]))));
                    }
                    if (tp.common().unique() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.common().unique()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.common", (Object[])new Object[0]))));
                    }
                    if (tp.uncommon().total() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.uncommon().total()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.uncommon", (Object[])new Object[0]))));
                    }
                    if (tp.uncommon().unique() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.uncommon().unique()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.uncommon", (Object[])new Object[0]))));
                    }
                    if (tp.rare().total() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.rare().total()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.rare", (Object[])new Object[0]))));
                    }
                    if (tp.rare().unique() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.rare().unique()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.rare", (Object[])new Object[0]))));
                    }
                    if (tp.epic().total() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.epic().total()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.epic", (Object[])new Object[0]))));
                    }
                    if (tp.epic().unique() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.epic().unique()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.epic", (Object[])new Object[0]))));
                    }
                    if (tp.legendary().total() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.legendary().total()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.legendary", (Object[])new Object[0]))));
                    }
                    if (tp.legendary().unique() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.legendary().unique()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.legendary", (Object[])new Object[0]))));
                    }
                    if (list.size() == 1) {
                        comp.add(Component.translatable((String)"tooltip.starcatcher.trophy.once").append((Component)list.getFirst()).append((Component)Component.translatable((String)"tooltip.starcatcher.trophy.have_been_caught")));
                    } else {
                        comp.add(Component.translatable((String)"tooltip.starcatcher.trophy.2"));
                        comp.addAll(list);
                    }
                } else {
                    comp.add(Component.translatable((String)"tooltip.libtooltips.generic.shift_up"));
                }
            }
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.FISHING_BOB.get(), FishingBobRenderer::new);
            EntityRenderers.register(ModEntities.BOTTLE.get(), ThrownItemRenderer::new);
            EntityRenderers.register(ModEntities.FISH.get(), FishRenderer::new);
            ModItemProperties.addCustomItemProperties();
        }

        @SubscribeEvent
        public static void FishSpotterLayer(RegisterGuiLayersEvent event) {
            event.registerAboveAll(Starcatcher.rl("fish_tracker"), (LayeredDraw.Layer)new FishTrackerLayer());
        }

        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ModParticles.FISHING_NOTIFICATION.get(), FishingNotificationParticles.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.FISHING_BITING.get(), FishingBitingParticles.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.FISHING_BITING_LAVA.get(), FishingBitingLavaParticles.Provider::new);
        }

        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register(ModMenuTypes.FISHING_ROD_MENU.get(), FishingRodScreen::new);
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(FishingBobModel.LAYER_LOCATION, FishingBobModel::createBodyLayer);
            event.registerLayerDefinition(AgaveBream.LAYER_LOCATION, AgaveBream::createBodyLayer);
            event.registerLayerDefinition(BigeyeTuna.LAYER_LOCATION, BigeyeTuna::createBodyLayer);
            event.registerLayerDefinition(Boreal.LAYER_LOCATION, Boreal::createBodyLayer);
            event.registerLayerDefinition(CactiFish.LAYER_LOCATION, CactiFish::createBodyLayer);
            event.registerLayerDefinition(Charfish.LAYER_LOCATION, Charfish::createBodyLayer);
            event.registerLayerDefinition(CrystalbackBoreal.LAYER_LOCATION, CrystalbackBoreal::createBodyLayer);
            event.registerLayerDefinition(CrystalbackMinnow.LAYER_LOCATION, CrystalbackMinnow::createBodyLayer);
            event.registerLayerDefinition(DeepjawHerring.LAYER_LOCATION, DeepjawHerring::createBodyLayer);
            event.registerLayerDefinition(DownfallBream.LAYER_LOCATION, DownfallBream::createBodyLayer);
            event.registerLayerDefinition(Driftfin.LAYER_LOCATION, Driftfin::createBodyLayer);
            event.registerLayerDefinition(DriftingBream.LAYER_LOCATION, DriftingBream::createBodyLayer);
            event.registerLayerDefinition(DusktailSnapper.LAYER_LOCATION, DusktailSnapper::createBodyLayer);
            event.registerLayerDefinition(LilySnapper.LAYER_LOCATION, LilySnapper::createBodyLayer);
            event.registerLayerDefinition(PinkKoi.LAYER_LOCATION, PinkKoi::createBodyLayer);
            event.registerLayerDefinition(SilverveilPerch.LAYER_LOCATION, SilverveilPerch::createBodyLayer);
            event.registerLayerDefinition(SludgeCatfish.LAYER_LOCATION, SludgeCatfish::createBodyLayer);
            event.registerLayerDefinition(Whiteveil.LAYER_LOCATION, Whiteveil::createBodyLayer);
            event.registerLayerDefinition(WillowBream.LAYER_LOCATION, WillowBream::createBodyLayer);
            event.registerLayerDefinition(WinteryPike.LAYER_LOCATION, WinteryPike::createBodyLayer);
        }
    }

    @EventBusSubscriber(modid="starcatcher")
    public static class ModEvents {
        @SubscribeEvent
        public static void addRegistry(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(FISH_REGISTRY, FishProperties.CODEC, FishProperties.CODEC, builder -> builder.maxId(512));
            event.dataPackRegistry(TROPHY_REGISTRY, TrophyProperties.CODEC, TrophyProperties.CODEC, builder -> builder.maxId(256));
        }

        @SubscribeEvent
        public static void registerAttributed(EntityAttributeCreationEvent event) {
            event.put(ModEntities.FISH.get(), FishEntity.createAttributes().build());
        }

        @SubscribeEvent
        public static void registerPayloads(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            registrar.playToClient(Payloads.FishingPayload.TYPE, Payloads.FishingPayload.STREAM_CODEC, PayloadReceiver::receiveFishingClient);
            registrar.playToServer(Payloads.FishingCompletedPayload.TYPE, Payloads.FishingCompletedPayload.STREAM_CODEC, PayloadReceiver::receiveFishingCompletedServer);
            registrar.playToClient(Payloads.FishCaughtPayload.TYPE, Payloads.FishCaughtPayload.STREAM_CODEC, PayloadReceiver::receiveFishCaught);
            registrar.playToServer(Payloads.FPsSeen.TYPE, Payloads.FPsSeen.STREAM_CODEC, PayloadReceiver::receiveFPsSeen);
        }
    }
}

